/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.lastaflute.di.util.LdiBigDecimalConversionUtil;
import org.lastaflute.di.util.LdiBigIntegerConversionUtil;
import org.lastaflute.di.util.LdiBooleanConversionUtil;
import org.lastaflute.di.util.LdiByteConversionUtil;
import org.lastaflute.di.util.LdiDecimalFormatSymbolsUtil;
import org.lastaflute.di.util.LdiDoubleConversionUtil;
import org.lastaflute.di.util.LdiFloatConversionUtil;
import org.lastaflute.di.util.LdiIntegerConversionUtil;
import org.lastaflute.di.util.LdiLongConversionUtil;
import org.lastaflute.di.util.LdiShortConversionUtil;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiNumberConversionUtil {
    protected LdiNumberConversionUtil() {
    }

    public static Object convertNumber(Class<?> type, Object o) {
        if (type == Integer.class) {
            return LdiIntegerConversionUtil.toInteger(o);
        }
        if (type == BigDecimal.class) {
            return LdiBigDecimalConversionUtil.toBigDecimal(o);
        }
        if (type == Double.class) {
            return LdiDoubleConversionUtil.toDouble(o);
        }
        if (type == Long.class) {
            return LdiLongConversionUtil.toLong(o);
        }
        if (type == Float.class) {
            return LdiFloatConversionUtil.toFloat(o);
        }
        if (type == Short.class) {
            return LdiShortConversionUtil.toShort(o);
        }
        if (type == BigInteger.class) {
            return LdiBigIntegerConversionUtil.toBigInteger(o);
        }
        if (type == Byte.class) {
            return LdiByteConversionUtil.toByte(o);
        }
        return o;
    }

    public static Object convertPrimitiveWrapper(Class<?> type, Object o) {
        if (type == Integer.TYPE) {
            Integer i = LdiIntegerConversionUtil.toInteger(o);
            if (i != null) {
                return i;
            }
            return 0;
        }
        if (type == Double.TYPE) {
            Double d = LdiDoubleConversionUtil.toDouble(o);
            if (d != null) {
                return d;
            }
            return new Double(0.0);
        }
        if (type == Long.TYPE) {
            Long l = LdiLongConversionUtil.toLong(o);
            if (l != null) {
                return l;
            }
            return 0L;
        }
        if (type == Float.TYPE) {
            Float f = LdiFloatConversionUtil.toFloat(o);
            if (f != null) {
                return f;
            }
            return new Float(0.0f);
        }
        if (type == Short.TYPE) {
            Short s = LdiShortConversionUtil.toShort(o);
            if (s != null) {
                return s;
            }
            return new Short(0);
        }
        if (type == Boolean.TYPE) {
            Boolean b = LdiBooleanConversionUtil.toBoolean(o);
            if (b != null) {
                return b;
            }
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE) {
            Byte b = LdiByteConversionUtil.toByte(o);
            if (b != null) {
                return b;
            }
            return new Byte(0);
        }
        return o;
    }

    public static String removeDelimeter(String value, Locale locale) {
        String groupingSeparator = LdiNumberConversionUtil.findGroupingSeparator(locale);
        if (groupingSeparator != null) {
            value = LdiStringUtil.replace(value, groupingSeparator, "");
        }
        return value;
    }

    public static String findGroupingSeparator(Locale locale) {
        DecimalFormatSymbols symbol = LdiNumberConversionUtil.getDecimalFormatSymbols(locale);
        return Character.toString(symbol.getGroupingSeparator());
    }

    public static String findDecimalSeparator(Locale locale) {
        DecimalFormatSymbols symbol = LdiNumberConversionUtil.getDecimalFormatSymbols(locale);
        return Character.toString(symbol.getDecimalSeparator());
    }

    private static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        DecimalFormatSymbols symbol = locale != null ? LdiDecimalFormatSymbolsUtil.getDecimalFormatSymbols(locale) : LdiDecimalFormatSymbolsUtil.getDecimalFormatSymbols();
        return symbol;
    }
}

