/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.util.ClassTraversal;
import org.lastaflute.di.util.LdiClassLoaderUtil;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiFileUtil;
import org.lastaflute.di.util.LdiInputStreamUtil;
import org.lastaflute.di.util.LdiJarFileUtil;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiStringUtil;
import org.lastaflute.di.util.LdiURLUtil;
import org.lastaflute.di.util.LdiZipFileUtil;
import org.lastaflute.di.util.LdiZipInputStreamUtil;
import org.lastaflute.di.util.ResourceTraversal;

public class LdiResourcesUtil {
    protected static final Resources[] EMPTY_ARRAY = new Resources[0];
    private static final LaLogger logger = LaLogger.getLogger(LdiResourcesUtil.class);
    protected static final Map<String, ResourcesFactory> resourcesTypeFactories = new HashMap<String, ResourcesFactory>();

    public static void addResourcesFactory(String protocol, ResourcesFactory factory) {
        resourcesTypeFactories.put(protocol, factory);
    }

    public static Resources getResourcesType(Class<?> referenceClass) {
        URL url = LdiResourceUtil.getResource(LdiResourcesUtil.toClassFile(referenceClass.getName()));
        String[] path = referenceClass.getName().split("\\.");
        String baseUrl = url.toExternalForm();
        for (int i = 0; i < path.length; ++i) {
            int pos = baseUrl.lastIndexOf(47);
            baseUrl = baseUrl.substring(0, pos);
        }
        return LdiResourcesUtil.getResourcesType(LdiURLUtil.create(baseUrl + '/'), null, null);
    }

    public static Resources getResourcesType(String rootDir) {
        URL url = LdiResourceUtil.getResource(rootDir.endsWith("/") ? rootDir : rootDir + '/');
        return LdiResourcesUtil.getResourcesType(url, null, rootDir);
    }

    public static Resources[] getResourcesTypes(String rootPackage) {
        if (LdiStringUtil.isEmpty(rootPackage)) {
            return EMPTY_ARRAY;
        }
        String baseName = LdiResourcesUtil.toDirectoryName(rootPackage);
        ArrayList<Resources> list = new ArrayList<Resources>();
        Iterator<URL> it = LdiClassLoaderUtil.getResources(baseName);
        while (it.hasNext()) {
            URL url = it.next();
            Resources resourcesType = LdiResourcesUtil.getResourcesType(url, rootPackage, baseName);
            if (resourcesType == null) continue;
            list.add(resourcesType);
        }
        if (list.isEmpty()) {
            logger.log("WSSR0014", new Object[]{rootPackage});
            return EMPTY_ARRAY;
        }
        return list.toArray(new Resources[list.size()]);
    }

    protected static Resources getResourcesType(URL url, String rootPackage, String rootDir) {
        ResourcesFactory factory = resourcesTypeFactories.get(LdiURLUtil.toCanonicalProtocol(url.getProtocol()));
        if (factory != null) {
            return factory.create(url, rootPackage, rootDir);
        }
        logger.log("WSSR0013", new Object[]{rootPackage, url});
        return null;
    }

    protected static String toDirectoryName(String packageName) {
        if (LdiStringUtil.isEmpty(packageName)) {
            return null;
        }
        return packageName.replace('.', '/') + '/';
    }

    protected static String toClassFile(String className) {
        return className.replace('.', '/') + ".class";
    }

    protected static File getBaseDir(URL url, String baseName) {
        File file = LdiURLUtil.toFile(url);
        String[] paths = LdiStringUtil.split(baseName, "/");
        for (int i = 0; i < paths.length; ++i) {
            file = file.getParentFile();
        }
        return file;
    }

    static {
        LdiResourcesUtil.addResourcesFactory("file", new ResourcesFactory(){

            @Override
            public Resources create(URL url, String rootPackage, String rootDir) {
                return new FileSystemResources(LdiResourcesUtil.getBaseDir(url, rootDir), rootPackage, rootDir);
            }
        });
        LdiResourcesUtil.addResourcesFactory("jar", new ResourcesFactory(){

            @Override
            public Resources create(URL url, String rootPackage, String rootDir) {
                return new JarFileResources(url, rootPackage, rootDir);
            }
        });
        LdiResourcesUtil.addResourcesFactory("zip", new ResourcesFactory(){

            @Override
            public Resources create(URL url, String rootPackage, String rootDir) {
                return new JarFileResources(LdiJarFileUtil.create(new File(LdiZipFileUtil.toZipFilePath(url))), rootPackage, rootDir);
            }
        });
        LdiResourcesUtil.addResourcesFactory("code-source", new ResourcesFactory(){

            @Override
            public Resources create(URL url, String rootPackage, String rootDir) {
                return new JarFileResources(LdiURLUtil.create("jar:file:" + url.getPath()), rootPackage, rootDir);
            }
        });
        LdiResourcesUtil.addResourcesFactory("vfszip", new ResourcesFactory(){

            @Override
            public Resources create(URL url, String rootPackage, String rootDir) {
                return new VfsZipResources(url, rootPackage, rootDir);
            }
        });
    }

    public static class VfsZipResources
    implements Resources {
        protected static final String WAR_CLASSES_PREFIX = "/WEB-INF/CLASSES/";
        protected final String rootPackage;
        protected final String rootDir;
        protected final URL zipUrl;
        protected final String prefix;
        protected final Set<String> entryNames = new HashSet<String>();

        public VfsZipResources(URL url, String rootPackage, String rootDir) {
            String zipUrlString;
            URL zipUrl = url;
            String prefix = "";
            if (rootPackage != null) {
                String[] paths = rootPackage.split("\\.");
                for (int i = 0; i < paths.length; ++i) {
                    zipUrl = LdiURLUtil.create(zipUrl, "..");
                }
            }
            this.loadFromZip(zipUrl);
            if (this.entryNames.isEmpty() && (zipUrlString = zipUrl.toExternalForm()).toUpperCase().endsWith(WAR_CLASSES_PREFIX)) {
                URL warUrl = LdiURLUtil.create(zipUrl, "../..");
                String path = warUrl.getPath();
                zipUrl = LdiFileUtil.toURL(new File(path.substring(0, path.length() - 1)));
                prefix = zipUrlString.substring(warUrl.toExternalForm().length());
                this.loadFromZip(zipUrl);
            }
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
            this.zipUrl = zipUrl;
            this.prefix = prefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadFromZip(URL zipUrl) {
            ZipInputStream zis = new ZipInputStream(LdiURLUtil.openStream(zipUrl));
            try {
                ZipEntry entry = null;
                while ((entry = LdiZipInputStreamUtil.getNextEntry(zis)) != null) {
                    this.entryNames.add(entry.getName());
                    LdiZipInputStreamUtil.closeEntry(zis);
                }
            }
            finally {
                LdiInputStreamUtil.close(zis);
            }
        }

        @Override
        public boolean isExistClass(String className) {
            String entryName = this.prefix + LdiResourcesUtil.toClassFile(LdiClassUtil.concatName(this.rootPackage, className));
            return this.entryNames.contains(entryName);
        }

        @Override
        public void forEach(final ClassTraversal.ClassHandler handler) {
            ZipInputStream zis = new ZipInputStream(LdiURLUtil.openStream(this.zipUrl));
            try {
                ClassTraversal.forEach(zis, this.prefix, new ClassTraversal.ClassHandler(){

                    @Override
                    public void processClass(String packageName, String shortClassName) {
                        if (rootPackage == null || packageName != null && packageName.startsWith(rootPackage)) {
                            handler.processClass(packageName, shortClassName);
                        }
                    }
                });
            }
            finally {
                LdiInputStreamUtil.close(zis);
            }
        }

        @Override
        public void forEach(final ResourceTraversal.ResourceHandler handler) {
            ZipInputStream zis = new ZipInputStream(LdiURLUtil.openStream(this.zipUrl));
            try {
                ResourceTraversal.forEach(zis, this.prefix, new ResourceTraversal.ResourceHandler(){

                    @Override
                    public void processResource(String path, InputStream is) {
                        if (rootDir == null || path.startsWith(rootDir)) {
                            handler.processResource(path, is);
                        }
                    }
                });
            }
            finally {
                LdiInputStreamUtil.close(zis);
            }
        }

        @Override
        public void close() {
        }
    }

    public static class JarFileResources
    implements Resources {
        protected final JarFile jarFile;
        protected final String rootPackage;
        protected final String rootDir;

        public JarFileResources(JarFile jarFile, String rootPackage, String rootDir) {
            this.jarFile = jarFile;
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
        }

        public JarFileResources(URL url, String rootPackage, String rootDir) {
            this(LdiJarFileUtil.toJarFile(url), rootPackage, rootDir);
        }

        @Override
        public boolean isExistClass(String className) {
            return this.jarFile.getEntry(LdiResourcesUtil.toClassFile(LdiClassUtil.concatName(this.rootPackage, className))) != null;
        }

        @Override
        public void forEach(final ClassTraversal.ClassHandler handler) {
            ClassTraversal.forEach(this.jarFile, new ClassTraversal.ClassHandler(){

                @Override
                public void processClass(String packageName, String shortClassName) {
                    if (rootPackage == null || packageName != null && packageName.startsWith(rootPackage)) {
                        handler.processClass(packageName, shortClassName);
                    }
                }
            });
        }

        @Override
        public void forEach(final ResourceTraversal.ResourceHandler handler) {
            ResourceTraversal.forEach(this.jarFile, new ResourceTraversal.ResourceHandler(){

                @Override
                public void processResource(String path, InputStream is) {
                    if (rootDir == null || path.startsWith(rootDir)) {
                        handler.processResource(path, is);
                    }
                }
            });
        }

        @Override
        public void close() {
            LdiJarFileUtil.close(this.jarFile);
        }
    }

    public static class FileSystemResources
    implements Resources {
        protected final File baseDir;
        protected final String rootPackage;
        protected final String rootDir;

        public FileSystemResources(File baseDir, String rootPackage, String rootDir) {
            this.baseDir = baseDir;
            this.rootPackage = rootPackage;
            this.rootDir = rootDir;
        }

        public FileSystemResources(URL url, String rootPackage, String rootDir) {
            this(LdiURLUtil.toFile(url), rootPackage, rootDir);
        }

        @Override
        public boolean isExistClass(String className) {
            File file = new File(this.baseDir, LdiResourcesUtil.toClassFile(LdiClassUtil.concatName(this.rootPackage, className)));
            return file.exists();
        }

        @Override
        public void forEach(ClassTraversal.ClassHandler handler) {
            ClassTraversal.forEach(this.baseDir, this.rootPackage, handler);
        }

        @Override
        public void forEach(ResourceTraversal.ResourceHandler handler) {
            ResourceTraversal.forEach(this.baseDir, this.rootDir, handler);
        }

        @Override
        public void close() {
        }
    }

    public static interface Resources {
        public boolean isExistClass(String var1);

        public void forEach(ClassTraversal.ClassHandler var1);

        public void forEach(ResourceTraversal.ResourceHandler var1);

        public void close();
    }

    public static interface ResourcesFactory {
        public Resources create(URL var1, String var2, String var3);
    }
}

