/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.jta.helper.timer;

import org.lastaflute.jta.helper.timer.LjtTimeoutTarget;

public class LjtTimeoutTask {
    private static final int ACTIVE = 0;
    private static final int STOPPED = 1;
    private static final int CANCELED = 2;
    private final LjtTimeoutTarget timeoutTarget_;
    private final long timeoutMillis_;
    private final boolean permanent_;
    private long startTime_;
    private int status_ = 0;

    LjtTimeoutTask(LjtTimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        this.timeoutTarget_ = timeoutTarget;
        this.timeoutMillis_ = (long)timeout * 1000L;
        this.permanent_ = permanent;
        this.startTime_ = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.startTime_ + this.timeoutMillis_;
    }

    void expired() {
        this.timeoutTarget_.expired();
    }

    public boolean isCanceled() {
        return this.status_ == 2;
    }

    public void cancel() {
        this.status_ = 2;
    }

    public boolean isStopped() {
        return this.status_ == 1;
    }

    public void stop() {
        if (this.status_ != 0) {
            String msg = "Failed to stop the timer because of illegal status: " + this.startTime_;
            throw new IllegalStateException(msg);
        }
        this.status_ = 1;
    }

    public void restart() {
        this.status_ = 0;
        this.startTime_ = System.currentTimeMillis();
    }

    public boolean isPermanent() {
        return this.permanent_;
    }
}

