/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.aop.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.lastaflute.di.core.aop.Pointcut;
import org.lastaflute.di.exception.EmptyRuntimeException;
import org.lastaflute.di.util.LdiMethodUtil;
import org.lastaflute.di.util.LdiModifierUtil;

public class PointcutImpl
implements Pointcut,
Serializable {
    private static final long serialVersionUID = 0L;
    private String[] methodNames;
    private Pattern[] patterns;
    private Method method;

    public PointcutImpl(Class<?> targetClass) throws EmptyRuntimeException {
        if (targetClass == null) {
            throw new EmptyRuntimeException("targetClass");
        }
        this.setMethodNames(PointcutImpl.getMethodNames(targetClass));
    }

    public PointcutImpl(String[] methodNames) throws EmptyRuntimeException {
        if (methodNames == null || methodNames.length == 0) {
            throw new EmptyRuntimeException("methodNames");
        }
        this.setMethodNames(methodNames);
    }

    public PointcutImpl(Method method) {
        this.method = method;
    }

    @Override
    public boolean isApplied(Method targetMethod) {
        if (this.method != null) {
            return this.method.equals(targetMethod);
        }
        String methodName = targetMethod.getName();
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(methodName).matches()) continue;
            return true;
        }
        return false;
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    private void setMethodNames(String[] methodNames) {
        this.methodNames = methodNames;
        this.patterns = new Pattern[methodNames.length];
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = Pattern.compile(methodNames[i]);
        }
    }

    private static String[] getMethodNames(Class<?> targetClass) {
        HashSet<String> methodNameSet = new HashSet<String>();
        if (targetClass.isInterface()) {
            PointcutImpl.addInterfaceMethodNames(methodNameSet, targetClass);
        }
        for (Class<?> clazz = targetClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                PointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
            }
        }
        if (methodNameSet.isEmpty()) {
            PointcutImpl.addClassMethodNames(methodNameSet, targetClass);
        }
        return methodNameSet.toArray(new String[methodNameSet.size()]);
    }

    private static void addInterfaceMethodNames(Set<String> methodNameSet, Class<?> interfaceClass) {
        Method[] methods = interfaceClass.getDeclaredMethods();
        for (int j = 0; j < methods.length; ++j) {
            methodNameSet.add(methods[j].getName());
        }
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            PointcutImpl.addInterfaceMethodNames(methodNameSet, interfaces[i]);
        }
    }

    private static void addClassMethodNames(Set<String> methodNameSet, Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (LdiMethodUtil.isSyntheticMethod(method) || LdiMethodUtil.isBridgeMethod(method) || LdiModifierUtil.isFinal(method) || method.getDeclaringClass() == Object.class) continue;
            methodNameSet.add(methods[i].getName());
        }
    }
}

