/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.external;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lastaflute.di.core.external.AbstractExternalContextMap;
import org.lastaflute.di.core.smart.hot.HotdeployClassLoader;
import org.lastaflute.di.core.smart.hot.HotdeployUtil;

public abstract class RebuildableExternalContextMap
extends AbstractExternalContextMap {
    protected static WeakReference<ClassLoader> hotdeployClassLoader = new WeakReference<Object>(null);
    protected static Set<Object> rebuiltNames = new HashSet<Object>(64);

    @Override
    public Object get(Object key) {
        Object value = this.getAttribute(key.toString());
        if (value == null || !this.isHotdeployMode()) {
            return value;
        }
        if (rebuiltNames.contains(key)) {
            return value;
        }
        Object rebuiltValue = HotdeployUtil.rebuildValue(value);
        rebuiltNames.add(key);
        this.setAttribute(key.toString(), rebuiltValue);
        return rebuiltValue;
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = super.put(key, value);
        if (this.isHotdeployMode()) {
            rebuiltNames.add(key);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected boolean isHotdeployMode() {
        if (!HotdeployUtil.isHotdeploy()) {
            return false;
        }
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (!(currentLoader instanceof HotdeployClassLoader)) {
            return false;
        }
        if (currentLoader != hotdeployClassLoader.get()) {
            hotdeployClassLoader = new WeakReference<ClassLoader>(currentLoader);
            rebuiltNames.clear();
        }
        return true;
    }
}

