/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.smart.hot;

import java.io.InputStream;
import org.lastaflute.di.core.smart.hot.HotdeployUtil;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.naming.NamingConvention;
import org.lastaflute.di.util.LdiClassUtil;
import org.lastaflute.di.util.LdiInputStreamUtil;
import org.lastaflute.di.util.LdiResourceUtil;

public class HotdeployClassLoader
extends ClassLoader {
    private static final LaLogger logger = LaLogger.getLogger(HotdeployClassLoader.class);
    protected final NamingConvention namingConvention;

    public HotdeployClassLoader(ClassLoader classLoader, NamingConvention namingConvention) {
        super(classLoader);
        this.namingConvention = namingConvention;
    }

    @Override
    public Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (HotdeployUtil.REBUILDER_CLASS_NAME.equals(className)) {
            Class<?> clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            return this.defineClass(className, resolve);
        }
        if (this.isTargetClass(className)) {
            Class<?> clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.findLoadedClassFromParentLoader(className);
            if (clazz != null) {
                logger.log("WSSR0015", new Object[]{className});
                return clazz;
            }
            clazz = this.defineClass(className, resolve);
            if (clazz != null) {
                return clazz;
            }
        }
        return super.loadClass(className, resolve);
    }

    protected Class<?> findLoadedClassFromParentLoader(String className) {
        return null;
    }

    protected Class<?> defineClass(String className, boolean resolve) {
        String path = LdiClassUtil.getResourcePath(className);
        InputStream is = LdiResourceUtil.getResourceAsStreamNoException(path);
        if (is != null) {
            Class<?> clazz = this.defineClass(className, is);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return null;
    }

    protected Class<?> defineClass(String className, InputStream classFile) {
        return this.defineClass(className, LdiInputStreamUtil.getBytes(classFile));
    }

    protected Class<?> defineClass(String className, byte[] bytes) {
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    protected boolean isTargetClass(String className) {
        return this.namingConvention.isHotdeployTargetClassName(className);
    }
}

