/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.timer;

import java.util.ArrayList;
import java.util.List;
import org.lastaflute.di.helper.timer.TimeoutLinkedList;
import org.lastaflute.di.helper.timer.TimeoutTarget;
import org.lastaflute.di.helper.timer.TimeoutTask;

public class TimeoutManager
implements Runnable {
    protected static final TimeoutManager instance = new TimeoutManager();
    protected Thread thread;
    protected final TimeoutLinkedList timeoutTaskList = new TimeoutLinkedList();

    private TimeoutManager() {
    }

    public static TimeoutManager getInstance() {
        return instance;
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Lasta_Di-TimeoutManager");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(long timeoutMillis) throws InterruptedException {
        Thread thread = this.thread;
        TimeoutManager timeoutManager = this;
        synchronized (timeoutManager) {
            if (thread == null) {
                return true;
            }
            this.thread = null;
        }
        thread.interrupt();
        thread.join(timeoutMillis);
        return !thread.isAlive();
    }

    public synchronized void clear() {
        this.timeoutTaskList.clear();
    }

    public synchronized TimeoutTask addTimeoutTarget(TimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        TimeoutTask task = new TimeoutTask(timeoutTarget, timeout, permanent);
        this.timeoutTaskList.addLast(task);
        if (this.timeoutTaskList.size() == 1) {
            this.start();
        }
        return task;
    }

    public synchronized int getTimeoutTaskCount() {
        return this.timeoutTaskList.size();
    }

    @Override
    public void run() {
        boolean interrupted = false;
        while (true) {
            List<TimeoutTask> expiredTask = this.getExpiredTask();
            for (TimeoutTask task : expiredTask) {
                task.expired();
                if (!task.isPermanent()) continue;
                task.restart();
            }
            if (interrupted || this.thread.isInterrupted() || this.stopIfLeisure()) {
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    protected synchronized List<TimeoutTask> getExpiredTask() {
        ArrayList<TimeoutTask> expiredTask = new ArrayList<TimeoutTask>();
        try {
            if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
                return expiredTask;
            }
        }
        catch (NullPointerException e) {
            return expiredTask;
        }
        for (TimeoutLinkedList.Entry e = this.timeoutTaskList.getFirstEntry(); e != null; e = e.getNext()) {
            TimeoutTask task = (TimeoutTask)e.getElement();
            if (task.isCanceled()) {
                e.remove();
                continue;
            }
            if (task.isStopped() || !task.isExpired()) continue;
            expiredTask.add(task);
            if (task.isPermanent()) continue;
            e.remove();
        }
        return expiredTask;
    }

    protected synchronized boolean stopIfLeisure() {
        try {
            if (this.timeoutTaskList == null || this.timeoutTaskList.isEmpty()) {
                this.thread = null;
                return true;
            }
        }
        catch (NullPointerException e) {
            return true;
        }
        return false;
    }
}

