/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.lastaflute.di.exception.IORuntimeException;
import org.lastaflute.di.util.LdiFileInputStreamUtil;
import org.lastaflute.di.util.LdiFileOutputStreamUtil;
import org.lastaflute.di.util.LdiInputStreamUtil;
import org.lastaflute.di.util.LdiOutputStreamUtil;

public class LdiFileUtil {
    protected LdiFileUtil() {
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL toURL(File file) {
        try {
            return file.toURL();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] getBytes(File file) {
        return LdiInputStreamUtil.getBytes(LdiFileInputStreamUtil.create(file));
    }

    public static void copy(File src, File dest) {
        if (dest.exists() && !dest.canWrite()) {
            return;
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            int length;
            in = new BufferedInputStream(LdiFileInputStreamUtil.create(src));
            out = new BufferedOutputStream(LdiFileOutputStreamUtil.create(dest));
            byte[] buf = new byte[1024];
            while (-1 < (length = in.read(buf))) {
                out.write(buf, 0, length);
                out.flush();
            }
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                LdiInputStreamUtil.close(in);
                LdiOutputStreamUtil.close(out);
                throw throwable;
            }
        }
        LdiInputStreamUtil.close(in);
        LdiOutputStreamUtil.close(out);
    }

    public static void write(String path, byte[] data) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        LdiFileUtil.write(path, data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String path, byte[] data, int offset, int length) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));){
            ((OutputStream)out).write(data, offset, length);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

