/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.lastaflute.di.util.LdiFileInputStreamUtil;
import org.lastaflute.di.util.LdiInputStreamReaderUtil;
import org.lastaflute.di.util.LdiReaderUtil;
import org.lastaflute.di.util.LdiResourceUtil;

public class LdiTextUtil {
    private static final String UTF8 = "UTF-8";

    protected LdiTextUtil() {
    }

    public static String readText(String path) {
        InputStream is = LdiResourceUtil.getResourceAsStream(path);
        InputStreamReader reader = LdiInputStreamReaderUtil.create(is);
        return LdiReaderUtil.readText(reader);
    }

    public static String readText(File file) {
        FileInputStream is = LdiFileInputStreamUtil.create(file);
        InputStreamReader reader = LdiInputStreamReaderUtil.create(is);
        return LdiReaderUtil.readText(reader);
    }

    public static String readUTF8(String path) {
        InputStream is = LdiResourceUtil.getResourceAsStream(path);
        InputStreamReader reader = LdiInputStreamReaderUtil.create(is, UTF8);
        return LdiReaderUtil.readText(reader);
    }

    public static String readUTF8(File file) {
        FileInputStream is = LdiFileInputStreamUtil.create(file);
        InputStreamReader reader = LdiInputStreamReaderUtil.create(is, UTF8);
        return LdiReaderUtil.readText(reader);
    }
}

