/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di;

import java.beans.Introspector;
import java.util.LinkedList;
import org.lastaflute.di.Disposable;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.util.LdiDriverManagerUtil;

public class DisposableUtil {
    protected static final LinkedList<Disposable> disposables = new LinkedList();

    public static synchronized void add(Disposable disposable) {
        disposables.add(disposable);
    }

    public static synchronized void remove(Disposable disposable) {
        disposables.remove(disposable);
    }

    public static synchronized void dispose() {
        while (!disposables.isEmpty()) {
            Disposable disposable = disposables.removeLast();
            try {
                disposable.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        disposables.clear();
        Introspector.flushCaches();
        LaLogger.dispose();
    }

    public static void deregisterAllDrivers() {
        LdiDriverManagerUtil.deregisterAllDrivers();
    }
}

