/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.assembler;

import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.assembler.AutoConstructorAssembler;
import org.lastaflute.di.core.assembler.AutoPropertyAssembler;
import org.lastaflute.di.core.assembler.ConstructorAssembler;
import org.lastaflute.di.core.assembler.DefaultConstructorConstructorAssembler;
import org.lastaflute.di.core.assembler.DefaultDestroyMethodAssembler;
import org.lastaflute.di.core.assembler.DefaultInitMethodAssembler;
import org.lastaflute.di.core.assembler.ManualOnlyPropertyAssembler;
import org.lastaflute.di.core.assembler.MethodAssembler;
import org.lastaflute.di.core.assembler.PropertyAssembler;
import org.lastaflute.di.core.assembler.SemiAutoPropertyAssembler;

public class AssemblerFactory {
    private static Provider provider = new DefaultProvider();

    public static MethodAssembler createInitMethodAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createInitMethodAssembler(cd);
    }

    public static MethodAssembler createDestroyMethodAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createDestroyMethodAssembler(cd);
    }

    public static ConstructorAssembler createAutoConstructorAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createAutoConstructorAssembler(cd);
    }

    public static ConstructorAssembler createDefaultConstructorConstructorAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createDefaultConstructorConstructorAssembler(cd);
    }

    public static PropertyAssembler createAutoPropertyAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createAutoPropertyAssembler(cd);
    }

    public static PropertyAssembler createManualOnlyPropertyAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createManualOnlyPropertyAssembler(cd);
    }

    public static PropertyAssembler createSemiAutoPropertyAssembler(ComponentDef cd) {
        return AssemblerFactory.getProvider().createSemiAutoPropertyAssembler(cd);
    }

    public static Provider getProvider() {
        return provider;
    }

    public static void setProvider(Provider p) {
        provider = p;
    }

    public static class DefaultProvider
    implements Provider {
        @Override
        public MethodAssembler createInitMethodAssembler(ComponentDef cd) {
            return new DefaultInitMethodAssembler(cd);
        }

        @Override
        public MethodAssembler createDestroyMethodAssembler(ComponentDef cd) {
            return new DefaultDestroyMethodAssembler(cd);
        }

        @Override
        public ConstructorAssembler createAutoConstructorAssembler(ComponentDef cd) {
            return new AutoConstructorAssembler(cd);
        }

        @Override
        public ConstructorAssembler createDefaultConstructorConstructorAssembler(ComponentDef cd) {
            return new DefaultConstructorConstructorAssembler(cd);
        }

        @Override
        public PropertyAssembler createAutoPropertyAssembler(ComponentDef cd) {
            return new AutoPropertyAssembler(cd);
        }

        @Override
        public PropertyAssembler createManualOnlyPropertyAssembler(ComponentDef cd) {
            return new ManualOnlyPropertyAssembler(cd);
        }

        @Override
        public PropertyAssembler createSemiAutoPropertyAssembler(ComponentDef cd) {
            return new SemiAutoPropertyAssembler(cd);
        }
    }

    public static interface Provider {
        public MethodAssembler createInitMethodAssembler(ComponentDef var1);

        public MethodAssembler createDestroyMethodAssembler(ComponentDef var1);

        public ConstructorAssembler createAutoConstructorAssembler(ComponentDef var1);

        public ConstructorAssembler createDefaultConstructorConstructorAssembler(ComponentDef var1);

        public PropertyAssembler createAutoPropertyAssembler(ComponentDef var1);

        public PropertyAssembler createManualOnlyPropertyAssembler(ComponentDef var1);

        public PropertyAssembler createSemiAutoPropertyAssembler(ComponentDef var1);
    }
}

