/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.expression.dwarf;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.exception.ExpressionClassCreateFailureException;
import org.lastaflute.di.helper.misc.LdiExceptionMessageBuilder;
import org.lastaflute.di.util.LdiSrl;

public class ExpressionCastResolver {
    public static final String CAST_INT_ARRAY = "(int[])";
    public static final String CAST_STRING_ARRAY = "(String[])";
    public static final String CAST_SET = "(Set)";

    public CastResolved resolveCast(String exp, Class<?> conversionType) {
        return this.doResolveCast(exp.trim());
    }

    protected CastResolved doResolveCast(String exp) {
        Class resolvedType;
        String filteredExp;
        if (exp.startsWith(CAST_INT_ARRAY)) {
            filteredExp = exp.substring(CAST_INT_ARRAY.length()).trim();
            resolvedType = int[].class;
        } else if (exp.startsWith(CAST_STRING_ARRAY)) {
            filteredExp = exp.substring(CAST_STRING_ARRAY.length()).trim();
            resolvedType = String[].class;
        } else if (exp.startsWith(CAST_SET)) {
            filteredExp = exp.substring(CAST_SET.length()).trim();
            resolvedType = Set.class;
        } else {
            return null;
        }
        return new CastResolved(filteredExp, resolvedType);
    }

    public Object convertListTo(String exp, LaContainer container, Class<?> resultType, List<Object> challengeList) {
        if (int[].class.isAssignableFrom(resultType)) {
            int[] intAry = new int[challengeList.size()];
            int index = 0;
            try {
                for (Object element : challengeList) {
                    if (element == null) {
                        throw new IllegalStateException("Cannot handle null element in array: index=" + index);
                    }
                    String numExp = LdiSrl.substringLastFront(element.toString(), ".0");
                    intAry[index] = Integer.parseInt(numExp);
                    ++index;
                }
            }
            catch (RuntimeException e) {
                this.throwExpressionCannotConvertException(exp, container, resultType, index, e);
            }
            return intAry;
        }
        if (String[].class.isAssignableFrom(resultType)) {
            String[] strAry = new String[challengeList.size()];
            int index = 0;
            try {
                for (Object element : challengeList) {
                    if (element == null) {
                        throw new IllegalStateException("Cannot handle null element in array: index=" + index);
                    }
                    if (!(element instanceof String)) {
                        throw new IllegalStateException("Non-string element in array: index=" + index);
                    }
                    strAry[index] = (String)element;
                    ++index;
                }
            }
            catch (RuntimeException e) {
                this.throwExpressionCannotConvertException(exp, container, resultType, index, e);
            }
            return strAry;
        }
        if (Set.class.isAssignableFrom(resultType)) {
            return new LinkedHashSet<Object>(challengeList);
        }
        return challengeList;
    }

    protected void throwExpressionCannotConvertException(String exp, LaContainer container, Class<?> conversionType, Integer index, RuntimeException cause) {
        LdiExceptionMessageBuilder br = new LdiExceptionMessageBuilder();
        br.addNotice("Failed to convert the value to the type in the expression.");
        br.addItem("Di XML");
        br.addElement(container.getPath());
        br.addItem("Expression");
        br.addElement(exp);
        br.addItem("Conversion Type");
        br.addElement(conversionType);
        if (index != null) {
            br.addItem("Array Index");
            br.addElement(index);
        }
        String msg = br.buildExceptionMessage();
        throw new ExpressionClassCreateFailureException(msg, cause);
    }

    public static class CastResolved {
        protected final String filteredExp;
        protected final Class<?> resolvedType;

        public CastResolved(String filteredExp, Class<?> resolvedType) {
            this.filteredExp = filteredExp;
            this.resolvedType = resolvedType;
        }

        public String getFilteredExp() {
            return this.filteredExp;
        }

        public Class<?> getResolvedType() {
            return this.resolvedType;
        }
    }
}

