/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.core.smart.hot;

import java.util.HashMap;
import java.util.Map;
import org.lastaflute.di.DisposableUtil;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.creator.ComponentCreator;
import org.lastaflute.di.core.factory.SingletonLaContainerFactory;
import org.lastaflute.di.core.meta.impl.LaContainerBehavior;
import org.lastaflute.di.core.meta.impl.LaContainerImpl;
import org.lastaflute.di.core.smart.hot.HotdeployClassLoader;
import org.lastaflute.di.core.util.ComponentUtil;
import org.lastaflute.di.helper.log.LaLogger;
import org.lastaflute.di.naming.NamingConvention;

public class HotdeployBehavior
extends LaContainerBehavior.DefaultProvider {
    private static final LaLogger logger = LaLogger.getLogger(HotdeployBehavior.class);
    private ClassLoader originalClassLoader;
    private HotdeployClassLoader hotdeployClassLoader;
    private Map<Object, ComponentDef> componentDefCache = new HashMap<Object, ComponentDef>();
    private NamingConvention namingConvention;
    private ComponentCreator[] creators = new ComponentCreator[0];
    public static final String keep_BINDING = "bindingType=may";
    private boolean keep;

    public void setKeep(boolean keep) {
        this.keep = keep;
        if (this.hotdeployClassLoader != null) {
            this.finish();
        }
    }

    public boolean isLaContainerHotdeploy() {
        return SingletonLaContainerFactory.getContainer().getClassLoader() instanceof HotdeployClassLoader;
    }

    public boolean isThreadContextHotdeploy() {
        return Thread.currentThread().getContextClassLoader() instanceof HotdeployClassLoader;
    }

    public void start() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (!this.keep || this.hotdeployClassLoader == null) {
            this.hotdeployClassLoader = new HotdeployClassLoader(this.originalClassLoader, this.namingConvention);
        }
        Thread.currentThread().setContextClassLoader(this.hotdeployClassLoader);
        LaContainer container = SingletonLaContainerFactory.getContainer();
        container.setClassLoader(this.hotdeployClassLoader);
    }

    public void stop() {
        if (!this.keep) {
            this.finish();
        }
        LaContainer container = SingletonLaContainerFactory.getContainer();
        container.setClassLoader(this.originalClassLoader);
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.originalClassLoader = null;
    }

    public void finish() {
        this.componentDefCache.clear();
        this.hotdeployClassLoader = null;
        DisposableUtil.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ComponentDef getComponentDef(LaContainer container, Object key) {
        HotdeployBehavior hotdeployBehavior = this;
        synchronized (hotdeployBehavior) {
            return this.doGetComponentDef(container, key);
        }
    }

    protected ComponentDef doGetComponentDef(LaContainer container, Object key) {
        ComponentDef cd = super.getComponentDef(container, key);
        if (cd != null) {
            return cd;
        }
        if (container != container.getRoot()) {
            return null;
        }
        cd = this.getComponentDefFromCache(key);
        if (cd != null) {
            return cd;
        }
        if (key instanceof Class) {
            cd = this.createComponentDef((Class)key);
        } else if (key instanceof String) {
            cd = this.createComponentDef((String)key);
            if (cd != null && !key.equals(cd.getComponentName())) {
                logger.log("WSSR0011", new Object[]{key, cd.getComponentClass().getName(), cd.getComponentName()});
                cd = null;
            }
        } else {
            throw new IllegalArgumentException("Illegal component key: " + key);
        }
        if (cd != null) {
            this.register(cd);
            ComponentUtil.putRegisterLog(cd);
            cd.init();
        }
        return cd;
    }

    protected ComponentDef getComponentDefFromCache(Object key) {
        return this.componentDefCache.get(key);
    }

    protected ComponentDef createComponentDef(Class<?> componentClass) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentClass);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    protected ComponentDef createComponentDef(String componentName) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentName);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    protected void register(ComponentDef componentDef) {
        componentDef.setContainer(SingletonLaContainerFactory.getContainer());
        this.registerByClass(componentDef);
        this.registerByName(componentDef);
    }

    protected void registerByClass(ComponentDef componentDef) {
        Class<?>[] classes = ComponentUtil.getAssignableClasses(componentDef.getComponentClass());
        for (int i = 0; i < classes.length; ++i) {
            this.registerMap(classes[i], componentDef);
        }
    }

    protected void registerByName(ComponentDef componentDef) {
        String componentName = componentDef.getComponentName();
        if (componentName != null) {
            this.registerMap(componentName, componentDef);
        }
    }

    protected void registerMap(Object key, ComponentDef componentDef) {
        ComponentDef previousCd = this.componentDefCache.get(key);
        if (previousCd == null) {
            this.componentDefCache.put(key, componentDef);
        } else {
            ComponentDef tmrcd = LaContainerImpl.createTooManyRegistration(key, previousCd, componentDef);
            this.componentDefCache.put(key, tmrcd);
        }
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public ComponentCreator[] getCreators() {
        return this.creators;
    }

    public void setCreators(ComponentCreator[] creators) {
        this.creators = creators;
    }
}

