/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.helper.message;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import org.lastaflute.di.core.smart.hot.HotdeployUtil;
import org.lastaflute.di.helper.message.MessageResourceBundle;
import org.lastaflute.di.helper.message.MessageResourceBundleImpl;
import org.lastaflute.di.util.LdiAssertionUtil;
import org.lastaflute.di.util.LdiFileInputStreamUtil;
import org.lastaflute.di.util.LdiInputStreamUtil;
import org.lastaflute.di.util.LdiPropertiesUtil;
import org.lastaflute.di.util.LdiResourceUtil;
import org.lastaflute.di.util.LdiURLUtil;

public class MessageResourceBundleFacade {
    protected File file;
    protected long lastModified;
    protected MessageResourceBundle bundle;
    protected MessageResourceBundleFacade parent;

    public MessageResourceBundleFacade(URL url) {
        this.setup(url);
    }

    protected void setup(URL url) {
        LdiAssertionUtil.assertNotNull("url", url);
        if (HotdeployUtil.isHotdeploy()) {
            this.file = LdiResourceUtil.getFile(url);
        }
        if (this.file != null) {
            this.lastModified = this.file.lastModified();
            this.bundle = this.createBundle(this.file);
        } else {
            this.bundle = this.createBundle(url);
        }
        if (this.parent != null) {
            this.bundle.setParent(this.parent.getBundle());
        }
    }

    public synchronized MessageResourceBundle getBundle() {
        if (this.isModified()) {
            this.bundle = this.createBundle(this.file);
        }
        if (this.parent != null) {
            this.bundle.setParent(this.parent.getBundle());
        }
        return this.bundle;
    }

    protected boolean isModified() {
        return this.file != null && this.file.lastModified() > this.lastModified;
    }

    protected MessageResourceBundle createBundle(File file) {
        return new MessageResourceBundleImpl(this.createProperties(file));
    }

    protected MessageResourceBundle createBundle(URL url) {
        return new MessageResourceBundleImpl(this.createProperties(url));
    }

    protected Properties createProperties(File file) {
        return this.createProperties(LdiFileInputStreamUtil.create(file));
    }

    protected Properties createProperties(URL url) {
        return this.createProperties(LdiURLUtil.openStream(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties createProperties(InputStream ins) {
        LdiAssertionUtil.assertNotNull("ins", ins);
        if (!(ins instanceof BufferedInputStream)) {
            ins = new BufferedInputStream(ins);
        }
        try {
            Properties prop = this.createProperties();
            this.loadProperties(prop, ins, this.getPropertiesEncoding());
            Properties properties = prop;
            return properties;
        }
        finally {
            LdiInputStreamUtil.close(ins);
        }
    }

    protected Properties createProperties() {
        return new Properties();
    }

    protected String getPropertiesEncoding() {
        return "UTF-8";
    }

    protected void loadProperties(Properties properties, InputStream ins, String encoding) {
        try {
            LdiPropertiesUtil.load(properties, new BufferedReader(new InputStreamReader(ins, encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported encoding: " + encoding);
        }
    }

    public synchronized MessageResourceBundleFacade getParent() {
        return this.parent;
    }

    public synchronized void setParent(MessageResourceBundleFacade parent) {
        this.parent = parent;
    }
}

