/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.redefiner.util;

import java.lang.reflect.Method;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.redefiner.LaContainerPreparer;

public class ClassBuilderUtils {
    protected ClassBuilderUtils() {
    }

    public static String toComponentName(String name) {
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    public static LaContainerPreparer getPreparer(ComponentDef componentDef) {
        LaContainer container = componentDef.getContainer();
        ComponentDef[] componentDefs = container.findLocalComponentDefs(LaContainerPreparer.class);
        if (componentDefs.length == 0) {
            return null;
        }
        return (LaContainerPreparer)componentDefs[0].getComponent();
    }

    public static Method findMethod(Class<?> clazz, String componentName, String prefix) {
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (!methodName.startsWith(prefix) || !componentName.equals(ClassBuilderUtils.toComponentName(methodName.substring(prefix.length())))) continue;
            return methods[i];
        }
        return null;
    }
}

