/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.di.util;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.lastaflute.di.exception.ParseRuntimeException;
import org.lastaflute.di.util.LdiStringUtil;

public class LdiTimeConversionUtil {
    protected LdiTimeConversionUtil() {
    }

    public static Time toTime(Object o) {
        return LdiTimeConversionUtil.toTime(o, null);
    }

    public static Time toTime(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return LdiTimeConversionUtil.toTime((String)o, pattern);
        }
        if (o instanceof Time) {
            return (Time)o;
        }
        if (o instanceof Calendar) {
            return new Time(((Calendar)o).getTime().getTime());
        }
        return LdiTimeConversionUtil.toTime(o.toString(), pattern);
    }

    public static Time toTime(String s, String pattern) {
        return LdiTimeConversionUtil.toTime(s, pattern, Locale.getDefault());
    }

    public static Time toTime(String s, String pattern, Locale locale) {
        if (LdiStringUtil.isEmpty(s)) {
            return null;
        }
        SimpleDateFormat sdf = LdiTimeConversionUtil.getDateFormat(s, pattern, locale);
        try {
            return new Time(sdf.parse(s).getTime());
        }
        catch (ParseException ex) {
            throw new ParseRuntimeException(ex);
        }
    }

    public static SimpleDateFormat getDateFormat(String s, String pattern, Locale locale) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern);
        }
        return LdiTimeConversionUtil.getDateFormat(s, locale);
    }

    public static SimpleDateFormat getDateFormat(String s, Locale locale) {
        String pattern = LdiTimeConversionUtil.getPattern(locale);
        if (s.length() == pattern.length()) {
            return new SimpleDateFormat(pattern);
        }
        String shortPattern = LdiTimeConversionUtil.convertShortPattern(pattern);
        if (s.length() == shortPattern.length()) {
            return new SimpleDateFormat(shortPattern);
        }
        return new SimpleDateFormat(pattern);
    }

    public static String getPattern(Locale locale) {
        return "HH:mm:ss";
    }

    public static String convertShortPattern(String pattern) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c != 'h' && c != 'H' && c != 'm' && c != 's') continue;
            buf.append(c);
        }
        return buf.toString();
    }
}

