/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.core.json.control.JsonControlMeta;
import org.lastaflute.core.json.engine.RealJsonEngine;
import org.lastaflute.meta.document.ActionDocumentAnalyzer;
import org.lastaflute.meta.document.DocumentAnalyzerFactory;
import org.lastaflute.meta.document.JobDocumentAnalyzer;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.outputmeta.OutputMetaSerializer;
import org.lastaflute.meta.infra.json.MetauseJsonEngineProvider;
import org.lastaflute.meta.sourceparser.SourceParserReflector;
import org.lastaflute.meta.sourceparser.SourceParserReflectorFactory;

public class DocumentGenerator {
    protected static final String DEFAULT_SRC_DIR = "src/main/java/";
    protected static final int DEFAULT_DEPTH = 4;
    protected final List<String> srcDirList;
    protected int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected boolean jobDocSuppressed;
    protected final DocumentAnalyzerFactory documentAnalyzerFactory = this.newDocumentGeneratorFactory();
    protected final MetauseJsonEngineProvider metauseJsonEngineProvider = this.newMetauseJsonEngineProvider();
    protected final OutputMetaSerializer outputMetaSerializer = this.newOutputMetaSerializer();

    protected DocumentAnalyzerFactory newDocumentGeneratorFactory() {
        return new DocumentAnalyzerFactory();
    }

    protected MetauseJsonEngineProvider newMetauseJsonEngineProvider() {
        return new MetauseJsonEngineProvider();
    }

    protected OutputMetaSerializer newOutputMetaSerializer() {
        return new OutputMetaSerializer();
    }

    public DocumentGenerator() {
        this.srcDirList = this.prepareDefaultSrcDirList();
        this.depth = 4;
        this.sourceParserReflector = this.prepareSourceParserReflector(this.srcDirList);
    }

    protected List<String> prepareDefaultSrcDirList() {
        ArrayList srcDirList = DfCollectionUtil.newArrayList();
        srcDirList.add(DEFAULT_SRC_DIR);
        String projectDirName = new File(".").getAbsoluteFile().getParentFile().getName();
        String commonDir = "../" + projectDirName.replaceAll("-.*", "-common") + "/" + DEFAULT_SRC_DIR;
        if (new File(commonDir).exists()) {
            srcDirList.add(commonDir);
        }
        return srcDirList;
    }

    public DocumentGenerator(List<String> srcDirList) {
        this.srcDirList = srcDirList;
        this.depth = 4;
        this.sourceParserReflector = this.prepareSourceParserReflector(srcDirList);
    }

    protected OptionalThing<SourceParserReflector> prepareSourceParserReflector(List<String> srcDirList) {
        return this.createSourceParserReflectorFactory().reflector(srcDirList);
    }

    protected SourceParserReflectorFactory createSourceParserReflectorFactory() {
        return new SourceParserReflectorFactory();
    }

    public void addSrcDir(String srcDir) {
        this.srcDirList.add(srcDir);
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public DocumentGenerator suppressJobDoc() {
        this.jobDocSuppressed = true;
        return this;
    }

    public void saveLastaDocMeta() {
        Map<String, Object> lastaMetaDetailMap = this.generateLastaDetailMap();
        String json = this.createJsonEngine().toJson(lastaMetaDetailMap);
        this.outputMetaSerializer.saveLastaDocMeta(json);
    }

    protected Map<String, Object> generateLastaDetailMap() {
        List<ActionDocMeta> actionDocMetaList = this.createActionDocumentAnalyzer().analyzeAction();
        LinkedHashMap lastaMetaDetailMap = DfCollectionUtil.newLinkedHashMap();
        lastaMetaDetailMap.put("actionDocMetaList", actionDocMetaList);
        this.createJobDocumentAnalyzer().ifPresent(jobDocumentGenerator -> lastaMetaDetailMap.put("jobDocMetaList", jobDocumentGenerator.analyzeJobDocMetaList()));
        return lastaMetaDetailMap;
    }

    public ActionDocumentAnalyzer createActionDocumentAnalyzer() {
        return this.documentAnalyzerFactory.createActionDocumentAnalyzer(this.srcDirList, this.depth, this.sourceParserReflector);
    }

    protected OptionalThing<JobDocumentAnalyzer> createJobDocumentAnalyzer() {
        if (this.jobDocSuppressed) {
            return OptionalThing.empty();
        }
        return this.documentAnalyzerFactory.createJobDocumentAnalyzer(this.srcDirList, this.depth, this.sourceParserReflector);
    }

    protected RealJsonEngine createJsonEngine() {
        return this.metauseJsonEngineProvider.createJsonEngine();
    }

    protected JsonControlMeta getAppJsonControlMeta() {
        return this.metauseJsonEngineProvider.getAppJsonControlMeta();
    }
}

