/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.core.direction.AccessibleConfig;
import org.lastaflute.core.json.control.JsonControlMeta;
import org.lastaflute.core.json.engine.RealJsonEngine;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.meta.DocumentGenerator;
import org.lastaflute.meta.SwaggerOption;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.outputmeta.OutputMetaSerializer;
import org.lastaflute.meta.document.parts.type.NativeDataTypeProvider;
import org.lastaflute.meta.infra.json.MetauseJsonEngineProvider;
import org.lastaflute.meta.swagger.json.SwaggerJsonReader;
import org.lastaflute.meta.swagger.spec.SwaggerSpecCreator;
import org.lastaflute.meta.swagger.spec.SwaggerSpecPathsMutableOutput;
import org.lastaflute.meta.swagger.spec.SwaggerSpecPathsSetupper;
import org.lastaflute.meta.swagger.web.LaActionSwaggerable;
import org.lastaflute.web.response.JsonResponse;
import org.lastaflute.web.util.LaRequestUtil;

public class SwaggerGenerator {
    protected final MetauseJsonEngineProvider jsonEngineProvider = this.newMetaJsonEngineProvider();
    protected final OutputMetaSerializer outputMetaSerializer = this.newOutputMetaSerializer();
    protected final NativeDataTypeProvider dataNativeTypeProvider = this.newDataNativeTypeProvider();

    protected MetauseJsonEngineProvider newMetaJsonEngineProvider() {
        return new MetauseJsonEngineProvider();
    }

    protected OutputMetaSerializer newOutputMetaSerializer() {
        return new OutputMetaSerializer();
    }

    protected NativeDataTypeProvider newDataNativeTypeProvider() {
        return new NativeDataTypeProvider();
    }

    public Map<String, Object> generateSwaggerMap() {
        return this.generateSwaggerMap(op -> {});
    }

    public Map<String, Object> generateSwaggerMap(Consumer<SwaggerOption> opLambda) {
        OptionalThing<Map<String, Object>> swaggerJson = this.readSwaggerJson();
        if (swaggerJson.isPresent()) {
            Map swaggerMap = (Map)swaggerJson.get();
            swaggerMap.put("schemes", this.prepareSwaggerMapSchemes());
            return swaggerMap;
        }
        return this.createSwaggerSpecMap(this.createSwaggerOption(opLambda));
    }

    protected OptionalThing<Map<String, Object>> readSwaggerJson() {
        return this.newSwaggerJsonReader(this.createJsonEngine()).readSwaggerJson();
    }

    protected SwaggerJsonReader newSwaggerJsonReader(RealJsonEngine jsonEngine) {
        return new SwaggerJsonReader(jsonEngine);
    }

    protected List<String> prepareSwaggerMapSchemes() {
        return Arrays.asList(this.getRequest().getScheme());
    }

    protected SwaggerOption createSwaggerOption(Consumer<SwaggerOption> opLambda) {
        SwaggerOption swaggerOption = new SwaggerOption();
        this.customizeSwaggerOption(swaggerOption);
        opLambda.accept(swaggerOption);
        return swaggerOption;
    }

    protected void customizeSwaggerOption(SwaggerOption swaggerOption) {
    }

    protected Map<String, Object> createSwaggerSpecMap(SwaggerOption swaggerOption) {
        SwaggerSpecCreator creator = this.newSwaggerSpecCreator(this.getAccessibleConfig(), this.getRequest());
        return creator.createSwaggerSpecMap(swaggerOption, (pathsMap, definitionsMap, tagsList) -> this.setupSwaggerPathsMap(pathsMap, definitionsMap, tagsList, swaggerOption));
    }

    protected SwaggerSpecCreator newSwaggerSpecCreator(AccessibleConfig accessibleConfig, HttpServletRequest currentRequest) {
        return new SwaggerSpecCreator(accessibleConfig, currentRequest);
    }

    protected void setupSwaggerPathsMap(Map<String, Map<String, Object>> pathsMap, Map<String, Map<String, Object>> definitionsMap, List<Map<String, Object>> tagsList, SwaggerOption swaggerOption) {
        SwaggerSpecPathsSetupper pathsSetupper = this.createSwaggerSpecPathsSetupper(pathsMap, definitionsMap, tagsList, swaggerOption);
        pathsSetupper.setupSwaggerPathsMap(this.filterActionDocMetaList(this.generateActionDocMetaList(swaggerOption)));
    }

    protected SwaggerSpecPathsSetupper createSwaggerSpecPathsSetupper(Map<String, Map<String, Object>> pathsMap, Map<String, Map<String, Object>> definitionsMap, List<Map<String, Object>> tagsList, SwaggerOption swaggerOption) {
        SwaggerSpecPathsMutableOutput pathMutableOutput = new SwaggerSpecPathsMutableOutput(pathsMap, definitionsMap, tagsList);
        RealJsonEngine swaggeruseJsonEngine = this.createJsonEngine();
        JsonControlMeta appJsonControlMeta = this.getAppJsonControlMeta();
        List<Class<?>> nativeDataTypeList = this.dataNativeTypeProvider.provideNativeDataTypeList();
        return this.newSwaggerSpecPathsSetupper(pathMutableOutput, swaggerOption, swaggeruseJsonEngine, appJsonControlMeta, nativeDataTypeList);
    }

    protected SwaggerSpecPathsSetupper newSwaggerSpecPathsSetupper(SwaggerSpecPathsMutableOutput pathMutableOutput, SwaggerOption swaggerOption, RealJsonEngine swaggeruseJsonEngine, JsonControlMeta appJsonControlMeta, List<Class<?>> nativeDataTypeList) {
        return new SwaggerSpecPathsSetupper(pathMutableOutput, swaggerOption, swaggeruseJsonEngine, appJsonControlMeta, nativeDataTypeList);
    }

    protected List<ActionDocMeta> generateActionDocMetaList(SwaggerOption swaggerOption) {
        DocumentGenerator documentGenerator = this.newDocumentGenerator();
        swaggerOption.getAdditionalSourceDirectories().ifPresent(consumer -> {
            ArrayList dirList = new ArrayList();
            consumer.accept(dirList);
            for (String dir : dirList) {
                documentGenerator.addSrcDir(dir);
            }
        });
        this.customizeActionDocumentGenerator(documentGenerator);
        return documentGenerator.createActionDocumentAnalyzer().analyzeAction();
    }

    protected DocumentGenerator newDocumentGenerator() {
        return new DocumentGenerator();
    }

    protected void customizeActionDocumentGenerator(DocumentGenerator documentGenerator) {
    }

    protected List<ActionDocMeta> filterActionDocMetaList(List<ActionDocMeta> actionDocMetaList) {
        return actionDocMetaList.stream().filter(meta -> !this.isSwaggerAction((ActionDocMeta)meta)).collect(Collectors.toList());
    }

    protected boolean isSwaggerAction(ActionDocMeta meta) {
        return LaActionSwaggerable.class.isAssignableFrom(meta.getType());
    }

    public void saveSwaggerMeta(LaActionSwaggerable swaggerable) {
        String json = this.extractActionJson(swaggerable);
        this.outputMetaSerializer.saveSwaggerMeta(json);
    }

    protected String extractActionJson(LaActionSwaggerable swaggerable) {
        JsonResponse<Map<String, Object>> jsonResponse = swaggerable.json();
        return this.createJsonEngine().toJson(jsonResponse.getJsonResult());
    }

    protected AccessibleConfig getAccessibleConfig() {
        return (AccessibleConfig)ContainerUtil.getComponent(AccessibleConfig.class);
    }

    protected HttpServletRequest getRequest() {
        return LaRequestUtil.getRequest();
    }

    protected RealJsonEngine createJsonEngine() {
        return this.jsonEngineProvider.createJsonEngine();
    }

    protected JsonControlMeta getAppJsonControlMeta() {
        return this.jsonEngineProvider.getAppJsonControlMeta();
    }
}

