/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.core.util.Lato;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.web.api.BusinessFailureMapping;

public class SwaggerOption {
    protected Function<String, String> basePathLambda;
    protected Supplier<String> applicationVersionOnUrlLambda;
    protected Consumer<List<String>> additionalSourceDirectoriesLambda;
    protected Function<ActionDocMeta, String> defaultFormHttpMethodLambda;
    protected Predicate<ActionDocMeta> targetActionDocMetaLambda;
    protected Function<ActionDocMeta, Integer> successHttpStatusLambda;
    protected Function<ActionDocMeta, SwaggerFailureHttpStatusResource> failureHttpStatusLambda;
    protected List<Map<String, Object>> headerParameterList;
    protected List<Map<String, Object>> securityDefinitionList;

    public void derivedBasePath(Function<String, String> oneArgLambda) {
        this.basePathLambda = oneArgLambda;
    }

    public void supplyApplicationVersionOnUrl(Supplier<String> noArgLambda) {
        this.applicationVersionOnUrlLambda = noArgLambda;
    }

    public void registerAdditionalSourceDirectory(Consumer<List<String>> oneArgLambda) {
        this.additionalSourceDirectoriesLambda = oneArgLambda;
    }

    public void derivedDefaultFormHttpMethod(Function<ActionDocMeta, String> oneArgLambda) {
        this.defaultFormHttpMethodLambda = oneArgLambda;
    }

    public void derivedTargetActionDocMeta(Predicate<ActionDocMeta> oneArgLambda) {
        this.targetActionDocMetaLambda = oneArgLambda;
    }

    public void derivedSuccessHttpStatus(Function<ActionDocMeta, Integer> oneArgLambda) {
        this.successHttpStatusLambda = oneArgLambda;
    }

    public void derivedFailureHttpStatus(Function<ActionDocMeta, SwaggerFailureHttpStatusResource> oneArgLambda) {
        this.failureHttpStatusLambda = oneArgLambda;
    }

    public void addHeaderParameter(String name, String value) {
        if (this.headerParameterList == null) {
            this.headerParameterList = DfCollectionUtil.newArrayList();
        }
        this.headerParameterList.add(this.createHeaderParameterMap(name, value));
    }

    public void addHeaderParameter(String name, String value, Consumer<SwaggerHeaderParameterResource> resourceLambda) {
        Map<String, Object> parameterMap = this.createHeaderParameterMap(name, value);
        resourceLambda.accept(new SwaggerHeaderParameterResource(parameterMap));
        if (this.headerParameterList == null) {
            this.headerParameterList = DfCollectionUtil.newArrayList();
        }
        this.headerParameterList.add(parameterMap);
    }

    protected Map<String, Object> createHeaderParameterMap(String name, String value) {
        LinkedHashMap parameterMap = DfCollectionUtil.newLinkedHashMap();
        parameterMap.put("in", "header");
        parameterMap.put("type", "string");
        parameterMap.put("required", true);
        parameterMap.put("name", name);
        parameterMap.put("default", value);
        return parameterMap;
    }

    public void addSecurityDefinition(String name) {
        if (this.securityDefinitionList == null) {
            this.securityDefinitionList = DfCollectionUtil.newArrayList();
        }
        this.securityDefinitionList.add(this.createSecurityDefinitionMap(name));
    }

    public void addSecurityDefinition(String name, Consumer<SwaggerSecurityDefinitionResource> resourceLambda) {
        Map<String, Object> definitionMap = this.createSecurityDefinitionMap(name);
        resourceLambda.accept(new SwaggerSecurityDefinitionResource(definitionMap));
        if (this.securityDefinitionList == null) {
            this.securityDefinitionList = DfCollectionUtil.newArrayList();
        }
        this.securityDefinitionList.add(definitionMap);
    }

    protected Map<String, Object> createSecurityDefinitionMap(String name) {
        LinkedHashMap definitionMap = DfCollectionUtil.newLinkedHashMap();
        definitionMap.put("in", "header");
        definitionMap.put("type", "apiKey");
        definitionMap.put("name", name);
        return definitionMap;
    }

    public String toString() {
        return Lato.string((Object)this);
    }

    public OptionalThing<Function<String, String>> getDerivedBasePath() {
        return OptionalThing.ofNullable(this.basePathLambda, () -> {
            throw new IllegalStateException("Not set basePathLambda.");
        });
    }

    public OptionalThing<Supplier<String>> getApplicationVersionOnUrl() {
        return OptionalThing.ofNullable(this.applicationVersionOnUrlLambda, () -> {
            throw new IllegalStateException("Not set applicationVersionOnUrlLambda.");
        });
    }

    public OptionalThing<Consumer<List<String>>> getAdditionalSourceDirectories() {
        return OptionalThing.ofNullable(this.additionalSourceDirectoriesLambda, () -> {
            throw new IllegalStateException("Not set additionalSourceDirectoriesLambda.");
        });
    }

    public Function<ActionDocMeta, String> getDefaultFormHttpMethod() {
        if (this.defaultFormHttpMethodLambda == null) {
            return meta -> "get";
        }
        return this.defaultFormHttpMethodLambda;
    }

    public Predicate<ActionDocMeta> getTargetActionDocMeta() {
        if (this.targetActionDocMetaLambda == null) {
            return actionDocMeta -> true;
        }
        return this.targetActionDocMetaLambda;
    }

    public OptionalThing<Function<ActionDocMeta, Integer>> getSuccessHttpStatusLambda() {
        return OptionalThing.ofNullable(this.successHttpStatusLambda, () -> {
            throw new IllegalStateException("Not set successHttpStatusLambda.");
        });
    }

    public OptionalThing<Function<ActionDocMeta, SwaggerFailureHttpStatusResource>> getFailureHttpStatusLambda() {
        return OptionalThing.ofNullable(this.failureHttpStatusLambda, () -> {
            throw new IllegalStateException("Not set failureHttpStatusLambda.");
        });
    }

    public OptionalThing<List<Map<String, Object>>> getHeaderParameterList() {
        return OptionalThing.ofNullable(this.headerParameterList, () -> {
            throw new IllegalStateException("Not set headerParameterList.");
        });
    }

    public OptionalThing<List<Map<String, Object>>> getSecurityDefinitionList() {
        return OptionalThing.ofNullable(this.securityDefinitionList, () -> {
            throw new IllegalStateException("Not set securityDefinitionList.");
        });
    }

    public static class SwaggerSecurityDefinitionResource {
        protected final Map<String, Object> securityDefinitionMap;

        public SwaggerSecurityDefinitionResource(Map<String, Object> securityDefinitionMap) {
            this.securityDefinitionMap = securityDefinitionMap;
        }

        public void registerAttribute(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("The argument 'key' should not be null.");
            }
            if (value == null) {
                throw new IllegalArgumentException("The argument 'value' should not be null.");
            }
            if (key.equalsIgnoreCase("name")) {
                throw new IllegalArgumentException("Cannot add '" + key + "' key here: " + key + ", " + value);
            }
            this.securityDefinitionMap.put(key, value);
        }
    }

    public static class SwaggerHeaderParameterResource {
        protected final Map<String, Object> headerParameterMap;

        public SwaggerHeaderParameterResource(Map<String, Object> headerParameterMap) {
            this.headerParameterMap = headerParameterMap;
        }

        public void registerAttribute(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("The argument 'key' should not be null.");
            }
            if (value == null) {
                throw new IllegalArgumentException("The argument 'value' should not be null.");
            }
            if (key.equalsIgnoreCase("name") || key.equalsIgnoreCase("default")) {
                throw new IllegalArgumentException("Cannot add '" + key + "' key here: " + key + ", " + value);
            }
            this.headerParameterMap.put(key, value);
        }
    }

    public static class SwaggerFailureHttpStatusResource {
        protected final Map<Integer, List<Class<?>>> failureStatusCauseMap = DfCollectionUtil.newLinkedHashMap();

        public void addMapping(int failureStatus, Class<?> causeType) {
            ArrayList existingList = this.failureStatusCauseMap.get(failureStatus);
            if (existingList == null) {
                existingList = DfCollectionUtil.newArrayList();
                this.failureStatusCauseMap.put(failureStatus, existingList);
            }
            existingList.add(causeType);
        }

        public void acceptFailureStatusMap(BusinessFailureMapping<Integer> failureMapping) {
            Map failureMap = failureMapping.getFailureMap();
            failureMap.forEach((causeType, httpStatus) -> this.addMapping((int)httpStatus, (Class<?>)causeType));
        }

        public Map<Integer, List<Class<?>>> getFailureStatusCauseMap() {
            return Collections.unmodifiableMap(this.failureStatusCauseMap);
        }
    }
}

