/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.agent.yourswagger;

import java.util.List;
import java.util.function.Consumer;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.util.Srl;
import org.lastaflute.meta.agent.outputmeta.OutputMetaAgent;
import org.lastaflute.meta.agent.yourswagger.YourSwaggerSyncOption;
import org.lastaflute.meta.exception.YourSwaggerDiffException;
import org.lastaflute.meta.swagger.diff.SwaggerDiff;
import org.lastaflute.meta.swagger.diff.SwaggerDiffOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YourSwaggerSyncAgent {
    private static final Logger logger = LoggerFactory.getLogger(YourSwaggerSyncAgent.class);

    public void verifyYourSwaggerSync(String locationPath, Consumer<YourSwaggerSyncOption> opLambda) {
        if (locationPath == null) {
            throw new IllegalArgumentException("The argument 'locationPath' should not be null.");
        }
        if (opLambda == null) {
            throw new IllegalArgumentException("The argument 'opLambda' should not be null.");
        }
        YourSwaggerSyncOption syncOption = this.createYourSwaggerSyncOption(opLambda);
        SwaggerDiff diff = this.createSwaggerDiff(syncOption);
        String outputSwaggerJsonPath = this.newOutputMetaAgent().getSwaggerJsonPath().toString();
        logger.debug("...Verifying that your swagger.json is synchronized with source codes: path={}", (Object)locationPath);
        String diffResult = diff.diffFromLocations(outputSwaggerJsonPath, locationPath);
        if (diffResult == null) {
            throw new IllegalStateException("The diffResult (from differ) should not be null: locationPath=" + locationPath);
        }
        if (diffResult.isEmpty()) {
            logger.debug("No difference, so your swagger synchronized with server implementation!");
            return;
        }
        String diffMessage = this.buildYourSwaggerDiffMessage(diffResult);
        if (!this.isLoggingResult(syncOption, diffResult)) {
            throw new YourSwaggerDiffException(diffMessage);
        }
        logger.info(diffMessage);
    }

    protected YourSwaggerSyncOption createYourSwaggerSyncOption(Consumer<YourSwaggerSyncOption> opLambda) {
        YourSwaggerSyncOption syncOption = new YourSwaggerSyncOption();
        opLambda.accept(syncOption);
        return syncOption;
    }

    protected SwaggerDiff createSwaggerDiff(YourSwaggerSyncOption syncOption) {
        List<Consumer<SwaggerDiffOption>> diffOptionSetupperList = syncOption.getSwaggerDiffOptionSetupperList();
        SwaggerDiff diff = this.newSwaggerDiff(op -> diffOptionSetupperList.forEach(setupper -> setupper.accept(op)));
        return diff;
    }

    protected SwaggerDiff newSwaggerDiff(Consumer<SwaggerDiffOption> opLambda) {
        return new SwaggerDiff(opLambda);
    }

    protected OutputMetaAgent newOutputMetaAgent() {
        return new OutputMetaAgent();
    }

    protected String buildYourSwaggerDiffMessage(String diffResult) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Found the differences between your swagger.json and source codes.");
        br.addItem("Advice");
        br.addElement((Object)"The application source codes should be synchronized with your swagger.json.");
        br.addElement((Object)"So make sure your source codes e.g. Action classes (or your swagger.json).");
        br.addElement((Object)"");
        br.addElement((Object)"Your swagger.json is treated as master.");
        br.addElement((Object)"So, for example, 'New' means 'Add it to source codes'.");
        br.addItem("Diff Result");
        br.addElement((Object)this.formatDiffResult(diffResult));
        return br.buildExceptionMessage();
    }

    protected String formatDiffResult(String diffResult) {
        String replaced = diffResult;
        replaced = Srl.replace((String)replaced, (String)"\n\n\n", (String)"\n");
        replaced = Srl.replace((String)replaced, (String)"\n\n", (String)"\n");
        replaced = Srl.replace((String)replaced, (String)"#### What's", (String)"\n\n#### What's");
        String changedLine = "#### What's Changed";
        if (replaced.contains("#### What's Changed")) {
            String front = Srl.substringFirstFront((String)replaced, (String[])new String[]{"#### What's Changed"});
            String rear = Srl.substringFirstRear((String)replaced, (String[])new String[]{"#### What's Changed"});
            rear = Srl.replace((String)rear, (String)"\n##### ", (String)"\n\n##### ");
            replaced = front + "#### What's Changed" + rear;
        }
        return replaced;
    }

    protected boolean isLoggingResult(YourSwaggerSyncOption syncOption, String diffResult) {
        return syncOption.isLoggingIfNewOnly() && this.isNewOnly(diffResult);
    }

    protected boolean isNewOnly(String diffResult) {
        return !diffResult.contains("Changed") && !diffResult.contains("Deleted");
    }
}

