/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.meta.document.BaseDocumentAnalyzer;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.document.parts.action.ExecuteMethodCollector;
import org.lastaflute.meta.document.parts.action.FormFieldNameAdjuster;
import org.lastaflute.meta.document.parts.type.NativeDataTypeProvider;
import org.lastaflute.meta.document.zone.formtype.ExecuteFormTypeAnalyzer;
import org.lastaflute.meta.document.zone.parameter.ExecuteParameterAnalyzer;
import org.lastaflute.meta.document.zone.returntype.ExecuteReturnTypeAnalyzer;
import org.lastaflute.meta.infra.json.MetauseJsonEngineProvider;
import org.lastaflute.meta.sourceparser.SourceParserReflector;
import org.lastaflute.web.UrlChain;
import org.lastaflute.web.path.ActionPathResolver;
import org.lastaflute.web.ruts.config.ActionExecute;
import org.lastaflute.web.ruts.config.ActionFormMeta;

public class ActionDocumentAnalyzer
extends BaseDocumentAnalyzer {
    protected final List<String> srcDirList;
    protected final int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected final MetauseJsonEngineProvider metauseJsonEngineProvider;
    protected final NativeDataTypeProvider nativeDataTypeProvider;
    protected final FormFieldNameAdjuster formFieldNameAdjuster;

    public ActionDocumentAnalyzer(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        this.srcDirList = srcDirList;
        this.depth = depth;
        this.sourceParserReflector = sourceParserReflector;
        this.metauseJsonEngineProvider = this.newMetauseJsonEngineProvider();
        this.nativeDataTypeProvider = this.newDataNativeTypeProvider();
        this.formFieldNameAdjuster = this.newFormFieldNameAdjuster(this.metauseJsonEngineProvider);
    }

    protected MetauseJsonEngineProvider newMetauseJsonEngineProvider() {
        return new MetauseJsonEngineProvider();
    }

    protected NativeDataTypeProvider newDataNativeTypeProvider() {
        return new NativeDataTypeProvider();
    }

    protected FormFieldNameAdjuster newFormFieldNameAdjuster(MetauseJsonEngineProvider metauseJsonEngineProvider) {
        return new FormFieldNameAdjuster(metauseJsonEngineProvider);
    }

    public List<ActionDocMeta> analyzeAction() {
        return this.createExecuteMethodCollector().collectActionExecuteList().stream().map(execute -> this.createActionDocMeta((ActionExecute)execute)).collect(Collectors.toList());
    }

    protected ExecuteMethodCollector createExecuteMethodCollector() {
        return new ExecuteMethodCollector(this.srcDirList, this.sourceParserReflector, execute -> this.exceptsActionExecute((ActionExecute)execute));
    }

    protected boolean exceptsActionExecute(ActionExecute actionExecute) {
        return false;
    }

    protected ActionDocMeta createActionDocMeta(ActionExecute execute) {
        ActionDocMeta actionDocMeta = new ActionDocMeta();
        Class actionClass = execute.getActionMapping().getActionDef().getComponentClass();
        UrlChain urlChain = this.prepareUrlChain(execute, actionClass);
        this.setupActionItem(actionDocMeta, actionClass, urlChain);
        Method executeMethod = execute.getExecuteMethod();
        Class<?> methodDeclaringClass = executeMethod.getDeclaringClass();
        this.setupClassItem(actionDocMeta, methodDeclaringClass);
        this.setupFieldItem(actionDocMeta, methodDeclaringClass);
        this.setupMethodItem(actionDocMeta, execute, executeMethod);
        this.setupAnnotationItem(actionDocMeta, executeMethod, methodDeclaringClass);
        this.setupInOutItem(actionDocMeta, execute, executeMethod);
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(actionDocMeta, executeMethod));
        return actionDocMeta;
    }

    protected UrlChain prepareUrlChain(ActionExecute execute, Class<?> actionClass) {
        UrlChain urlChain = new UrlChain(actionClass);
        String urlPattern = execute.getPreparedUrlPattern().getResolvedUrlPattern();
        if (!"index".equals(urlPattern)) {
            urlChain.moreUrl(new Object[]{urlPattern});
        }
        return urlChain;
    }

    protected void setupActionItem(ActionDocMeta actionDocMeta, Class<?> actionClass, UrlChain urlChain) {
        ActionPathResolver actionPathResolver = (ActionPathResolver)ContainerUtil.getComponent(ActionPathResolver.class);
        actionDocMeta.setUrl(actionPathResolver.toActionUrl(actionClass, urlChain));
    }

    protected void setupClassItem(ActionDocMeta actionDocMeta, Class<?> methodDeclaringClass) {
        actionDocMeta.setType(methodDeclaringClass);
        actionDocMeta.setTypeName(this.adjustTypeName(methodDeclaringClass));
        actionDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(methodDeclaringClass));
    }

    protected void setupFieldItem(ActionDocMeta actionDocMeta, Class<?> methodDeclaringClass) {
        actionDocMeta.setFieldTypeDocMetaList(Arrays.stream(methodDeclaringClass.getDeclaredFields()).map(field -> {
            TypeDocMeta typeDocMeta = new TypeDocMeta();
            typeDocMeta.setName(this.formFieldNameAdjuster.adjustFieldName(methodDeclaringClass, (Field)field));
            typeDocMeta.setPublicName(this.formFieldNameAdjuster.adjustPublicFieldName(null, (Field)field));
            typeDocMeta.setType(field.getType());
            typeDocMeta.setTypeName(this.adjustTypeName(field.getGenericType()));
            typeDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(field.getGenericType()));
            typeDocMeta.setAnnotationTypeList(Arrays.asList(field.getAnnotations()));
            typeDocMeta.setAnnotationList(this.arrangeAnnotationList(typeDocMeta.getAnnotationTypeList()));
            this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(typeDocMeta, field.getType()));
            return typeDocMeta;
        }).collect(Collectors.toList()));
    }

    protected void setupMethodItem(ActionDocMeta actionDocMeta, ActionExecute execute, Method executeMethod) {
        actionDocMeta.setActionExecute(execute);
        actionDocMeta.setMethodName(executeMethod.getName());
    }

    protected void setupAnnotationItem(ActionDocMeta actionDocMeta, Method executeMethod, Class<?> methodDeclaringClass) {
        ArrayList annotationList = DfCollectionUtil.newArrayList();
        annotationList.addAll(Arrays.asList(methodDeclaringClass.getAnnotations()));
        annotationList.addAll(Arrays.asList(executeMethod.getAnnotations()));
        actionDocMeta.setAnnotationTypeList(annotationList);
        actionDocMeta.setAnnotationList(this.arrangeAnnotationList(annotationList));
    }

    protected void setupInOutItem(ActionDocMeta actionDocMeta, ActionExecute execute, Method executeMethod) {
        ArrayList parameterTypeDocMetaList = DfCollectionUtil.newArrayList();
        Arrays.stream(executeMethod.getParameters()).filter(parameter -> !execute.getFormMeta().isPresent() || !((ActionFormMeta)execute.getFormMeta().get()).getSymbolFormType().equals(parameter.getType())).forEach(parameter -> {
            actionDocMeta.setUrl(this.buildNewActionUrl(actionDocMeta, (Parameter)parameter));
            parameterTypeDocMetaList.add(this.analyzeMethodParameter((Parameter)parameter));
        });
        actionDocMeta.setParameterTypeDocMetaList(parameterTypeDocMetaList);
        this.analyzeFormClass(execute).ifPresent(formTypeDocMeta -> actionDocMeta.setFormTypeDocMeta((TypeDocMeta)formTypeDocMeta));
        actionDocMeta.setReturnTypeDocMeta(this.analyzeReturnClass(executeMethod));
    }

    protected String buildNewActionUrl(ActionDocMeta actionDocMeta, Parameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append("{").append(parameter.getName()).append("}");
        return actionDocMeta.getUrl().replaceFirst("\\{\\}", builder.toString());
    }

    protected TypeDocMeta analyzeMethodParameter(Parameter parameter) {
        return this.createExecuteParameterAnalyzer().analyzeMethodParameter(parameter);
    }

    protected ExecuteParameterAnalyzer createExecuteParameterAnalyzer() {
        return new ExecuteParameterAnalyzer(this.sourceParserReflector, this.metaAnnotationArranger, this.metaTypeNameAdjuster);
    }

    protected OptionalThing<TypeDocMeta> analyzeFormClass(ActionExecute execute) {
        return this.createExecuteFormTypeAnalyzer().analyzeFormClass(execute);
    }

    protected ExecuteFormTypeAnalyzer createExecuteFormTypeAnalyzer() {
        return new ExecuteFormTypeAnalyzer(this.depth, this.sourceParserReflector, this.metaAnnotationArranger, this.metaTypeNameAdjuster, this.formFieldNameAdjuster);
    }

    protected TypeDocMeta analyzeReturnClass(Method method) {
        return this.createExecuteReturnTypeAnalyzer().analyzeReturnClass(method);
    }

    protected ExecuteReturnTypeAnalyzer createExecuteReturnTypeAnalyzer() {
        return new ExecuteReturnTypeAnalyzer(this.depth, this.sourceParserReflector, this.metaAnnotationArranger, this.metaTypeNameAdjuster, this.nativeDataTypeProvider, this.formFieldNameAdjuster);
    }
}

