/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document;

import java.util.List;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfReflectionUtil;
import org.lastaflute.meta.document.ActionDocumentAnalyzer;
import org.lastaflute.meta.document.JobDocumentAnalyzer;
import org.lastaflute.meta.sourceparser.SourceParserReflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentAnalyzerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DocumentAnalyzerFactory.class);
    private static final String JOB_MANAGER_CLASS_NAME = "org.lastaflute.job.JobManager";

    public ActionDocumentAnalyzer createActionDocumentAnalyzer(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        return new ActionDocumentAnalyzer(srcDirList, depth, sourceParserReflector);
    }

    public OptionalThing<JobDocumentAnalyzer> createJobDocumentAnalyzer(List<String> srcDirList, int depth, OptionalThing<SourceParserReflector> sourceParserReflector) {
        JobDocumentAnalyzer generator;
        String className = JOB_MANAGER_CLASS_NAME;
        try {
            DfReflectionUtil.forName((String)JOB_MANAGER_CLASS_NAME);
            logger.debug("...Loading lasta job for document: {}", (Object)JOB_MANAGER_CLASS_NAME);
            generator = new JobDocumentAnalyzer(srcDirList, depth, sourceParserReflector);
        }
        catch (DfReflectionUtil.ReflectionFailureException ignored) {
            generator = null;
        }
        return OptionalThing.ofNullable(generator, () -> {
            throw new IllegalStateException("Not found the lasta job: org.lastaflute.job.JobManager");
        });
    }
}

