/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.outputmeta;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.lastaflute.meta.document.outputmeta.OutputMetaPhysical;

public class OutputMetaSerializer {
    protected final OutputMetaPhysical analyzedMetaPhysical = this.newAnalyzedMetaPhysical();

    protected OutputMetaPhysical newAnalyzedMetaPhysical() {
        return new OutputMetaPhysical();
    }

    public void saveLastaDocMeta(String json) {
        this.doSaveOutputMeta(json, this.analyzedMetaPhysical.getLastaDocJsonPath());
    }

    public void saveSwaggerMeta(String json) {
        this.doSaveOutputMeta(json, this.analyzedMetaPhysical.getSwaggerJsonPath());
    }

    protected void doSaveOutputMeta(String json, Path path) {
        if (json == null) {
            throw new IllegalArgumentException("The argument 'json' should not be null.");
        }
        Path parentPath = path.getParent();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create directory: " + parentPath, e);
            }
        }
        try (BufferedWriter bw = Files.newBufferedWriter(path, Charset.forName("UTF-8"), new OpenOption[0]);){
            bw.write(json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write the json to the file: " + path, e);
        }
    }
}

