/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.parts.action;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.di.core.ComponentDef;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.SingletonLaContainerFactory;
import org.lastaflute.meta.sourceparser.SourceParserReflector;
import org.lastaflute.web.Execute;
import org.lastaflute.web.ruts.config.ActionExecute;
import org.lastaflute.web.ruts.config.ActionMapping;
import org.lastaflute.web.ruts.config.ModuleConfig;
import org.lastaflute.web.util.LaModuleConfigUtil;

public class ExecuteMethodCollector {
    protected final List<String> srcDirList;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected final Predicate<ActionExecute> exceptingPredicate;

    public ExecuteMethodCollector(List<String> srcDirList, OptionalThing<SourceParserReflector> sourceParserReflector, Predicate<ActionExecute> exceptingPredicate) {
        this.srcDirList = srcDirList;
        this.sourceParserReflector = sourceParserReflector;
        this.exceptingPredicate = exceptingPredicate;
    }

    public List<ActionExecute> collectActionExecuteList() {
        ArrayList<ActionExecute> actionExecuteList = new ArrayList<ActionExecute>();
        ModuleConfig moduleConfig = LaModuleConfigUtil.getModuleConfig();
        this.findActionComponentNameList().forEach(componentName -> moduleConfig.findActionMapping(componentName).alwaysPresent(actionMapping -> {
            ArrayList<ActionExecute> candidateExecuteList = new ArrayList<ActionExecute>(actionMapping.getExecuteList());
            this.orderBySourceIfPossible((List<ActionExecute>)candidateExecuteList, (ActionMapping)actionMapping);
            candidateExecuteList.stream().filter(ex -> !this.exceptingPredicate.test((ActionExecute)ex)).forEach(execute -> actionExecuteList.add((ActionExecute)execute));
        }));
        return actionExecuteList;
    }

    protected List<String> findActionComponentNameList() {
        ArrayList componentNameList = DfCollectionUtil.newArrayList();
        LaContainer container = this.getRootContainer();
        this.srcDirList.stream().filter(srcDir -> Paths.get(srcDir, new String[0]).toFile().exists()).forEach(srcDir -> {
            try (Stream<Path> stream = Files.find(Paths.get(srcDir, new String[0]), Integer.MAX_VALUE, (path, attr) -> path.toString().endsWith("Action.java"), new FileVisitOption[0]);){
                stream.sorted().map(path -> {
                    String className = this.extractActionClassName((Path)path, (String)srcDir);
                    return DfReflectionUtil.forName((String)className);
                }).filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).forEach(clazz -> {
                    String componentName = container.getComponentDef(clazz).getComponentName();
                    if (componentName != null && !componentNameList.contains(componentName)) {
                        componentNameList.add(componentName);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to find the components: " + srcDir, e);
            }
        });
        IntStream.range(0, container.getComponentDefSize()).forEach(index -> {
            ComponentDef componentDef = container.getComponentDef(index);
            String componentName = componentDef.getComponentName();
            if (componentName.endsWith("Action") && !componentNameList.contains(componentName)) {
                componentNameList.add(componentDef.getComponentName());
            }
        });
        return componentNameList;
    }

    protected LaContainer getRootContainer() {
        return SingletonLaContainerFactory.getContainer().getRoot();
    }

    protected String extractActionClassName(Path path, String srcDir) {
        String className = DfStringUtil.substringFirstRear((String)path.toFile().getAbsolutePath(), (String[])new String[]{new File(srcDir).getAbsolutePath()});
        if (className.startsWith(File.separator)) {
            className = className.substring(1);
        }
        className = DfStringUtil.substringLastFront((String)className, (String[])new String[]{".java"}).replace(File.separatorChar, '.');
        return className;
    }

    protected void orderBySourceIfPossible(List<ActionExecute> candidateExecuteList, ActionMapping actionMapping) {
        List<Method> sourceOrderList = this.extractSourceOrderedExecuteMethodList(actionMapping);
        if (!sourceOrderList.isEmpty()) {
            DfCollectionUtil.AccordingToOrderResource resource = new DfCollectionUtil.AccordingToOrderResource();
            resource.setupResource(sourceOrderList, exec -> exec.getExecuteMethod());
            DfCollectionUtil.orderAccordingTo(candidateExecuteList, (DfCollectionUtil.AccordingToOrderResource)resource);
        }
    }

    protected List<Method> extractSourceOrderedExecuteMethodList(ActionMapping actionMapping) {
        ArrayList sourceOrderList = DfCollectionUtil.newArrayList();
        this.sourceParserReflector.ifPresent(sourceParserReflector -> {
            Class actionClass = actionMapping.getActionDef().getComponentClass();
            List<Method> allMethodList = sourceParserReflector.getMethodListOrderByDefinition(actionClass);
            allMethodList.stream().filter(mt -> mt.getAnnotation(Execute.class) != null).forEach(mt -> sourceOrderList.add(mt));
        });
        return sourceOrderList;
    }
}

