/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.parts.action;

import com.google.gson.FieldNamingPolicy;
import java.lang.reflect.Field;
import org.lastaflute.core.json.JsonMappingOption;
import org.lastaflute.core.json.control.JsonControlMeta;
import org.lastaflute.meta.infra.json.MetauseJsonEngineProvider;

public class FormFieldNameAdjuster {
    protected final MetauseJsonEngineProvider metauseJsonEngineProvider;

    public FormFieldNameAdjuster(MetauseJsonEngineProvider metauseJsonEngineProvider) {
        this.metauseJsonEngineProvider = metauseJsonEngineProvider;
    }

    public String adjustFieldName(Class<?> clazz, Field field) {
        return field.getName();
    }

    public String adjustPublicFieldName(Class<?> clazz, Field field) {
        if (clazz == null || this.isActionFormComponentType(clazz)) {
            return field.getName();
        }
        return (String)this.getAppJsonControlMeta().getMappingControlMeta().flatMap(meta -> meta.getFieldNaming().map(naming -> {
            if (naming == JsonMappingOption.JsonFieldNaming.IDENTITY) {
                return FieldNamingPolicy.IDENTITY.translateName(field);
            }
            if (naming == JsonMappingOption.JsonFieldNaming.CAMEL_TO_LOWER_SNAKE) {
                return FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES.translateName(field);
            }
            return field.getName();
        })).orElse((Object)field.getName());
    }

    protected boolean isActionFormComponentType(Class<?> clazz) {
        return clazz.getSimpleName().endsWith("Form") || clazz.getName().contains("Form$");
    }

    protected JsonControlMeta getAppJsonControlMeta() {
        return this.metauseJsonEngineProvider.getAppJsonControlMeta();
    }
}

