/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.parts.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.dbflute.util.DfReflectionUtil;
import org.lastaflute.meta.document.parts.type.MetaTypeNameAdjuster;

public class MetaAnnotationArranger {
    private final MetaTypeNameAdjuster metaTypeNameAdjuster;

    public MetaAnnotationArranger(MetaTypeNameAdjuster metaTypeNameAdjuster) {
        this.metaTypeNameAdjuster = metaTypeNameAdjuster;
    }

    public List<String> arrangeAnnotationList(List<Annotation> annotationList) {
        return annotationList.stream().map(annotation -> {
            Map<String, Object> methodMap = this.extractAnnotationMethodMap((Annotation)annotation);
            String typeName = this.adjustSimpleTypeName(annotation.annotationType());
            if (methodMap.isEmpty()) {
                return typeName;
            }
            return this.connectTypeAndAttribute(typeName, methodMap);
        }).collect(Collectors.toList());
    }

    protected Map<String, Object> extractAnnotationMethodMap(Annotation annotation) {
        return Arrays.stream(annotation.annotationType().getDeclaredMethods()).filter(method -> this.isValueSpecifiedAttribute(annotation, (Method)method)).collect(this.toMap(annotation));
    }

    protected boolean isValueSpecifiedAttribute(Annotation annotation, Method method) {
        Object defaultValue;
        Object value = DfReflectionUtil.invoke((Method)method, (Object)annotation, (Object[])null);
        if (this.isAttributeValueSimpleDefault(value, defaultValue = method.getDefaultValue())) {
            return false;
        }
        return !this.isArrayAttributeValueDefault(method, value, defaultValue);
    }

    protected boolean isAttributeValueSimpleDefault(Object value, Object defaultValue) {
        return Objects.equals(value, defaultValue);
    }

    protected boolean isArrayAttributeValueDefault(Method method, Object value, Object defaultValue) {
        return method.getReturnType().isArray() && Arrays.equals((Object[])value, (Object[])defaultValue);
    }

    protected Collector<Method, ?, TreeMap<String, Object>> toMap(Annotation annotation) {
        return Collectors.toMap(method -> method.getName(), method -> this.extractAttributeValue(annotation, (Method)method), (u, v) -> v, TreeMap::new);
    }

    protected Object extractAttributeValue(Annotation annotation, Method method) {
        List data = DfReflectionUtil.invoke((Method)method, (Object)annotation, (Object[])null);
        if (data != null && data.getClass().isArray()) {
            List<Object> dataList = Arrays.asList((Object[])data);
            if (dataList.isEmpty()) {
                return "";
            }
            data = dataList.stream().map(element -> element instanceof Class ? this.adjustSimpleTypeName((Class)element) : element).collect(Collectors.toList());
        }
        return data;
    }

    protected String connectTypeAndAttribute(String typeName, Map<String, Object> methodMap) {
        return typeName + methodMap;
    }

    protected String adjustTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustTypeName(type);
    }

    protected String adjustTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustTypeName(typeName);
    }

    protected String adjustSimpleTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(type);
    }

    protected String adjustSimpleTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(typeName);
    }
}

