/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.zone.formtype;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.document.parts.action.FormFieldNameAdjuster;
import org.lastaflute.meta.document.parts.annotation.MetaAnnotationArranger;
import org.lastaflute.meta.document.parts.type.MetaTypeNameAdjuster;
import org.lastaflute.meta.document.zone.properties.ActionPropertiesAnalyzer;
import org.lastaflute.meta.sourceparser.SourceParserReflector;
import org.lastaflute.web.ruts.config.ActionExecute;

public class ExecuteFormTypeAnalyzer {
    protected final int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected final MetaAnnotationArranger metaAnnotationArranger;
    protected final MetaTypeNameAdjuster metaTypeNameAdjuster;
    protected final FormFieldNameAdjuster formFieldNameAdjuster;

    public ExecuteFormTypeAnalyzer(int depth, OptionalThing<SourceParserReflector> sourceParserReflector, MetaAnnotationArranger metaAnnotationArranger, MetaTypeNameAdjuster metaTypeNameAdjuster, FormFieldNameAdjuster formFieldNameAdjuster) {
        this.depth = depth;
        this.sourceParserReflector = sourceParserReflector;
        this.metaAnnotationArranger = metaAnnotationArranger;
        this.metaTypeNameAdjuster = metaTypeNameAdjuster;
        this.formFieldNameAdjuster = formFieldNameAdjuster;
    }

    public OptionalThing<TypeDocMeta> analyzeFormClass(ActionExecute execute) {
        return execute.getFormMeta().map(lastafluteFormMeta -> {
            TypeDocMeta formDocMeta = new TypeDocMeta();
            lastafluteFormMeta.getListFormParameterParameterizedType().ifPresent(type -> {
                formDocMeta.setType(lastafluteFormMeta.getSymbolFormType());
                formDocMeta.setTypeName(this.adjustTypeName((Type)type));
                formDocMeta.setSimpleTypeName(this.adjustSimpleTypeName((Type)type));
            }).orElse(() -> {
                formDocMeta.setType(lastafluteFormMeta.getSymbolFormType());
                formDocMeta.setTypeName(this.adjustTypeName(lastafluteFormMeta.getSymbolFormType()));
                formDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(lastafluteFormMeta.getSymbolFormType()));
            });
            Class formType = (Class)lastafluteFormMeta.getListFormParameterGenericType().orElse((Object)lastafluteFormMeta.getSymbolFormType());
            Map genericParameterTypesMap = DfCollectionUtil.emptyMap();
            List<TypeDocMeta> propertyDocMetaList = this.analyzeProperties(genericParameterTypesMap, formType);
            formDocMeta.setNestTypeDocMetaList(propertyDocMetaList);
            this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(formDocMeta, formType));
            return formDocMeta;
        });
    }

    protected List<TypeDocMeta> analyzeProperties(Map<String, Type> genericParameterTypesMap, Class<?> propertyOwner) {
        ActionPropertiesAnalyzer propertiesAnalyzer = this.createActionPropertiesAnalyzer(genericParameterTypesMap);
        return propertiesAnalyzer.analyzeProperties(propertyOwner, this.depth);
    }

    protected ActionPropertiesAnalyzer createActionPropertiesAnalyzer(Map<String, Type> genericParameterTypesMap) {
        return new ActionPropertiesAnalyzer(this.sourceParserReflector, genericParameterTypesMap, this.metaAnnotationArranger, this.metaTypeNameAdjuster, this.formFieldNameAdjuster);
    }

    protected String adjustTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustTypeName(type);
    }

    protected String adjustTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustTypeName(typeName);
    }

    protected String adjustSimpleTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(type);
    }

    protected String adjustSimpleTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(typeName);
    }
}

