/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.zone.parameter;

import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfReflectionUtil;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.document.parts.annotation.MetaAnnotationArranger;
import org.lastaflute.meta.document.parts.type.MetaTypeNameAdjuster;
import org.lastaflute.meta.sourceparser.SourceParserReflector;

public class ExecuteParameterAnalyzer {
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected final MetaAnnotationArranger metaAnnotationArranger;
    protected final MetaTypeNameAdjuster metaTypeNameAdjuster;

    public ExecuteParameterAnalyzer(OptionalThing<SourceParserReflector> sourceParserReflector, MetaAnnotationArranger metaAnnotationArranger, MetaTypeNameAdjuster metaTypeNameAdjuster) {
        this.sourceParserReflector = sourceParserReflector;
        this.metaAnnotationArranger = metaAnnotationArranger;
        this.metaTypeNameAdjuster = metaTypeNameAdjuster;
    }

    public TypeDocMeta analyzeMethodParameter(Parameter parameter) {
        TypeDocMeta parameterDocMeta = new TypeDocMeta();
        parameterDocMeta.setName(parameter.getName());
        parameterDocMeta.setPublicName(parameter.getName());
        parameterDocMeta.setType(parameter.getType());
        parameterDocMeta.setTypeName(this.adjustTypeName(parameter.getParameterizedType()));
        parameterDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(parameter.getParameterizedType()));
        if (OptionalThing.class.isAssignableFrom(parameter.getType())) {
            parameterDocMeta.setGenericType(DfReflectionUtil.getGenericFirstClass((Type)parameter.getParameterizedType()));
        }
        parameterDocMeta.setAnnotationTypeList(Arrays.asList(parameter.getAnnotatedType().getAnnotations()));
        parameterDocMeta.setAnnotationList(this.metaAnnotationArranger.arrangeAnnotationList(parameterDocMeta.getAnnotationTypeList()));
        parameterDocMeta.setNestTypeDocMetaList(Collections.emptyList());
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(parameterDocMeta, parameter.getType()));
        return parameterDocMeta;
    }

    protected String adjustTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustTypeName(type);
    }

    protected String adjustTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustTypeName(typeName);
    }

    protected String adjustSimpleTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(type);
    }

    protected String adjustSimpleTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(typeName);
    }
}

