/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.zone.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.document.parts.action.FormFieldNameAdjuster;
import org.lastaflute.meta.document.parts.annotation.MetaAnnotationArranger;
import org.lastaflute.meta.document.parts.type.MetaTypeNameAdjuster;
import org.lastaflute.meta.document.zone.properties.ActionPropertyFieldAnalyzer;
import org.lastaflute.meta.sourceparser.SourceParserReflector;

public class ActionPropertiesAnalyzer {
    protected static final Set<String> SUPPRESSED_FIELD_SET = DfCollectionUtil.newHashSet((Object[])new String[]{"$jacocoData"});
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected final Map<String, Type> genericParameterTypesMap;
    protected final MetaAnnotationArranger metaAnnotationArranger;
    protected final MetaTypeNameAdjuster metaTypeNameAdjuster;
    protected final FormFieldNameAdjuster formFieldNameAdjuster;

    public ActionPropertiesAnalyzer(OptionalThing<SourceParserReflector> sourceParserReflector, Map<String, Type> genericParameterTypesMap, MetaAnnotationArranger metaAnnotationArranger, MetaTypeNameAdjuster metaTypeNameAdjuster, FormFieldNameAdjuster formFieldNameAdjuster) {
        this.sourceParserReflector = sourceParserReflector;
        this.genericParameterTypesMap = genericParameterTypesMap;
        this.metaAnnotationArranger = metaAnnotationArranger;
        this.metaTypeNameAdjuster = metaTypeNameAdjuster;
        this.formFieldNameAdjuster = formFieldNameAdjuster;
    }

    public List<TypeDocMeta> analyzeProperties(Class<?> propertyOwner, int depth) {
        if (depth < 0) {
            return DfCollectionUtil.newArrayList();
        }
        Set<Field> fieldSet = this.extractWholeFieldSet(propertyOwner);
        return fieldSet.stream().filter(field -> !this.exceptsField((Field)field)).map(field -> this.analyzePropertyField(propertyOwner, depth, (Field)field)).collect(Collectors.toList());
    }

    protected Set<Field> extractWholeFieldSet(Class<?> propertyOwner) {
        LinkedHashSet fieldSet = DfCollectionUtil.newLinkedHashSet();
        for (Class<?> targetClazz = propertyOwner; targetClazz != Object.class && targetClazz != null; targetClazz = targetClazz.getSuperclass()) {
            fieldSet.addAll(Arrays.asList(targetClazz.getDeclaredFields()));
        }
        return fieldSet;
    }

    protected boolean exceptsField(Field field) {
        return SUPPRESSED_FIELD_SET.contains(field.getName()) || Modifier.isStatic(field.getModifiers());
    }

    protected TypeDocMeta analyzePropertyField(Class<?> propertyOwner, int depth, Field field) {
        ActionPropertyFieldAnalyzer fieldAnalyzer = this.createActionPropertyFieldAnalyzer();
        return fieldAnalyzer.analyzePropertyField(propertyOwner, depth, field);
    }

    protected ActionPropertyFieldAnalyzer createActionPropertyFieldAnalyzer() {
        return new ActionPropertyFieldAnalyzer(this.sourceParserReflector, this.genericParameterTypesMap, this.metaAnnotationArranger, this.metaTypeNameAdjuster, this.formFieldNameAdjuster, this);
    }
}

