/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.zone.properties;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.jdbc.Classification;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfReflectionUtil;
import org.lastaflute.di.util.tiger.LdiGenericUtil;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.document.parts.action.FormFieldNameAdjuster;
import org.lastaflute.meta.document.parts.annotation.MetaAnnotationArranger;
import org.lastaflute.meta.document.parts.type.MetaTypeNameAdjuster;
import org.lastaflute.meta.document.zone.properties.ActionPropertiesAnalyzer;
import org.lastaflute.meta.sourceparser.SourceParserReflector;

public class ActionPropertyFieldAnalyzer {
    protected static final List<String> ROOT_TARGET_SUFFIX_LIST = Arrays.asList("Form", "Body", "Bean", "Result", "Part");
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected final Map<String, Type> genericParameterTypesMap;
    protected final MetaAnnotationArranger metaAnnotationArranger;
    protected final MetaTypeNameAdjuster metaTypeNameAdjuster;
    protected final FormFieldNameAdjuster formFieldNameAdjuster;
    protected final ActionPropertiesAnalyzer actionPropertiesAnalyzer;

    public ActionPropertyFieldAnalyzer(OptionalThing<SourceParserReflector> sourceParserReflector, Map<String, Type> genericParameterTypesMap, MetaAnnotationArranger metaAnnotationArranger, MetaTypeNameAdjuster metaTypeNameAdjuster, FormFieldNameAdjuster formFieldNameAdjuster, ActionPropertiesAnalyzer actionPropertiesAnalyzer) {
        this.sourceParserReflector = sourceParserReflector;
        this.genericParameterTypesMap = genericParameterTypesMap;
        this.metaAnnotationArranger = metaAnnotationArranger;
        this.metaTypeNameAdjuster = metaTypeNameAdjuster;
        this.formFieldNameAdjuster = formFieldNameAdjuster;
        this.actionPropertiesAnalyzer = actionPropertiesAnalyzer;
    }

    public TypeDocMeta analyzePropertyField(Class<?> propertyOwner, int depth, Field field) {
        TypeDocMeta meta = new TypeDocMeta();
        Class<?> resolvedClass = this.reflectBasicAnalysisToMeta(field, meta);
        this.reflectNestAnalysisToMeta(depth, field, meta, resolvedClass);
        this.sourceParserReflector.ifPresent(sourceParserReflector -> sourceParserReflector.reflect(meta, propertyOwner));
        meta.setName(this.adjustFieldName(propertyOwner, field));
        meta.setPublicName(this.adjustPublicFieldName(propertyOwner, field));
        return meta;
    }

    protected Class<?> reflectBasicAnalysisToMeta(Field field, TypeDocMeta meta) {
        Class genericClass = this.genericParameterTypesMap.get(field.getGenericType().getTypeName());
        Class resolvedType = genericClass != null ? genericClass : field.getType();
        meta.setName(field.getName());
        meta.setPublicName(this.adjustPublicFieldName(null, field));
        meta.setType(field.getType());
        meta.setTypeName(this.adjustTypeName(resolvedType));
        meta.setSimpleTypeName(this.adjustSimpleTypeName(resolvedType));
        meta.setAnnotationTypeList(Arrays.asList(field.getAnnotations()));
        meta.setAnnotationList(this.metaAnnotationArranger.arrangeAnnotationList(meta.getAnnotationTypeList()));
        Class resolvedClass = resolvedType instanceof Class ? resolvedType : (Class)DfReflectionUtil.getGenericParameterTypes(resolvedType)[0];
        if (resolvedClass.isEnum()) {
            meta.setValue(this.buildEnumValuesExp(resolvedClass));
        }
        return resolvedClass;
    }

    protected void reflectNestAnalysisToMeta(int depth, Field field, TypeDocMeta meta, Class<?> resolvedClass) {
        int nestDepth = depth - 1;
        if (this.isTargetSuffixResolvedClass(resolvedClass)) {
            List<TypeDocMeta> nestTypeDocMetaList = this.actionPropertiesAnalyzer.analyzeProperties(resolvedClass, nestDepth);
            meta.setNestTypeDocMetaList(nestTypeDocMetaList);
        } else if (this.isTargetSuffixFieldGeneric(field)) {
            Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            if (type instanceof Class) {
                Class typeArgumentClass = (Class)type;
                List<TypeDocMeta> nestTypeDocMetaList = this.actionPropertiesAnalyzer.analyzeProperties(typeArgumentClass, nestDepth);
                meta.setNestTypeDocMetaList(nestTypeDocMetaList);
                String currentTypeName = meta.getTypeName();
                meta.setTypeName(this.buildGenericTwoLayerTypeName(typeArgumentClass, currentTypeName));
                meta.setSimpleTypeName(this.buildGenericTwoLayerSimpleTypeName(typeArgumentClass, currentTypeName));
            } else if (type instanceof ParameterizedType) {
                Class typeArgumentClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                List<TypeDocMeta> nestTypeDocMetaList = this.actionPropertiesAnalyzer.analyzeProperties(typeArgumentClass, nestDepth);
                meta.setNestTypeDocMetaList(nestTypeDocMetaList);
                String currentTypeName = meta.getTypeName();
                meta.setTypeName(this.buildGenericThreeLayerTypeName(type, typeArgumentClass, currentTypeName));
                meta.setSimpleTypeName(this.buildGenericThreeLayerSimpleTypeName(type, typeArgumentClass, currentTypeName));
            }
        } else {
            Type fieldGenericType = field.getGenericType();
            if (fieldGenericType.getTypeName().matches(".*<(.*)>")) {
                String genericTypeName = fieldGenericType.getTypeName().replaceAll(".*<(.*)>", "$1");
                try {
                    meta.setGenericType(DfReflectionUtil.forName((String)genericTypeName));
                }
                catch (DfReflectionUtil.ReflectionFailureException ignored) {
                    meta.setGenericType(Object.class);
                }
                Type genericClass = this.genericParameterTypesMap.get(genericTypeName);
                if (genericClass != null) {
                    List<TypeDocMeta> nestTypeDocMetaList = this.actionPropertiesAnalyzer.analyzeProperties((Class)genericClass, nestDepth);
                    meta.setNestTypeDocMetaList(nestTypeDocMetaList);
                    String typeName = meta.getTypeName();
                    meta.setTypeName(this.adjustTypeName(typeName) + "<" + this.adjustTypeName(genericClass) + ">");
                    meta.setSimpleTypeName(this.adjustSimpleTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericClass) + ">");
                } else {
                    String typeName = meta.getTypeName();
                    meta.setTypeName(this.adjustTypeName(typeName) + "<" + this.adjustTypeName(genericTypeName) + ">");
                    meta.setSimpleTypeName(this.adjustSimpleTypeName(typeName) + "<" + this.adjustSimpleTypeName(genericTypeName) + ">");
                    Class genericFirstClass = LdiGenericUtil.getGenericFirstClass((Type)fieldGenericType);
                    if (genericFirstClass != null && genericFirstClass.isEnum()) {
                        meta.setValue(this.buildEnumValuesExp(genericFirstClass));
                    }
                }
            }
        }
    }

    protected String buildGenericTwoLayerTypeName(Class<?> typeArgumentClass, String currentTypeName) {
        return this.adjustTypeName(currentTypeName) + "<" + this.adjustTypeName(typeArgumentClass) + ">";
    }

    protected String buildGenericTwoLayerSimpleTypeName(Class<?> typeArgumentClass, String currentTypeName) {
        return this.adjustSimpleTypeName(currentTypeName) + "<" + this.adjustSimpleTypeName(typeArgumentClass) + ">";
    }

    protected String buildGenericThreeLayerTypeName(Type type, Class<?> typeArgumentClass, String currentTypeName) {
        String rootType = this.adjustTypeName(currentTypeName);
        String nestType = this.adjustTypeName(((ParameterizedType)type).getRawType());
        String moreNestType = this.adjustTypeName(typeArgumentClass);
        return rootType + "<" + nestType + "<" + moreNestType + ">>";
    }

    protected String buildGenericThreeLayerSimpleTypeName(Type type, Class<?> typeArgumentClass, String currentTypeName) {
        String rootType = this.adjustSimpleTypeName(currentTypeName);
        String nestType = this.adjustSimpleTypeName(((ParameterizedType)type).getRawType());
        String moreNestType = this.adjustSimpleTypeName(typeArgumentClass);
        return rootType + "<" + nestType + "<" + moreNestType + ">>";
    }

    protected String buildEnumValuesExp(Class<?> typeClass) {
        String valuesExp;
        if (Classification.class.isAssignableFrom(typeClass)) {
            Class<?> clsType = typeClass;
            valuesExp = Arrays.stream(clsType.getEnumConstants()).collect(Collectors.toMap(keyMapper -> keyMapper.code(), valueMapper -> valueMapper.alias(), (u, v) -> v, LinkedHashMap::new)).toString();
        } else {
            Enum[] constants = (Enum[])typeClass.getEnumConstants();
            valuesExp = Arrays.stream(constants).collect(Collectors.toList()).toString();
        }
        return valuesExp;
    }

    protected boolean isTargetSuffixResolvedClass(Class<?> resolvedClass) {
        return this.getTargetTypeSuffixList().stream().anyMatch(suffix -> {
            String fqcn = resolvedClass.getName();
            return this.determineTargetSuffixResolvedClass(fqcn, (String)suffix);
        });
    }

    protected boolean isTargetSuffixFieldGeneric(Field field) {
        Type genericType = field.getGenericType();
        String genericTypeName = genericType.getTypeName();
        if (!genericTypeName.contains("<") || !genericTypeName.contains(">")) {
            return false;
        }
        Class genericFirstClass = LdiGenericUtil.getGenericFirstClass((Type)genericType);
        if (genericFirstClass == null) {
            return false;
        }
        String fqcn = genericFirstClass.getName();
        return this.getTargetTypeSuffixList().stream().anyMatch(suffix -> this.determineTargetSuffixResolvedClass(fqcn, (String)suffix));
    }

    protected List<String> getTargetTypeSuffixList() {
        return ROOT_TARGET_SUFFIX_LIST;
    }

    protected boolean determineTargetSuffixResolvedClass(String fqcn, String suffix) {
        return fqcn.endsWith(suffix) || fqcn.contains(suffix + "$");
    }

    protected String adjustFieldName(Class<?> clazz, Field field) {
        return this.formFieldNameAdjuster.adjustFieldName(clazz, field);
    }

    protected String adjustPublicFieldName(Class<?> clazz, Field field) {
        return this.formFieldNameAdjuster.adjustPublicFieldName(clazz, field);
    }

    protected String adjustTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustTypeName(type);
    }

    protected String adjustTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustTypeName(typeName);
    }

    protected String adjustSimpleTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(type);
    }

    protected String adjustSimpleTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(typeName);
    }
}

