/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.document.zone.returntype;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.document.parts.action.FormFieldNameAdjuster;
import org.lastaflute.meta.document.parts.annotation.MetaAnnotationArranger;
import org.lastaflute.meta.document.parts.type.MetaTypeNameAdjuster;
import org.lastaflute.meta.document.parts.type.NativeDataTypeProvider;
import org.lastaflute.meta.document.zone.properties.ActionPropertiesAnalyzer;
import org.lastaflute.meta.sourceparser.SourceParserReflector;
import org.lastaflute.meta.util.LaDocReflectionUtil;

public class ExecuteReturnTypeAnalyzer {
    protected static final Set<String> SUPPRESSED_FIELD_SET = DfCollectionUtil.newHashSet((Object[])new String[]{"$jacocoData"});
    protected static final List<String> TARGET_SUFFIX_LIST = Arrays.asList("Form", "Body", "Bean", "Result");
    protected final int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected final MetaAnnotationArranger metaAnnotationArranger;
    protected final MetaTypeNameAdjuster metaTypeNameAdjuster;
    protected final NativeDataTypeProvider nativeDataTypeProvider;
    protected final FormFieldNameAdjuster formFieldNameAdjuster;

    public ExecuteReturnTypeAnalyzer(int depth, OptionalThing<SourceParserReflector> sourceParserReflector, MetaAnnotationArranger metaAnnotationArranger, MetaTypeNameAdjuster metaTypeNameAdjuster, NativeDataTypeProvider nativeDataTypeProvider, FormFieldNameAdjuster formFieldNameAdjuster) {
        this.depth = depth;
        this.sourceParserReflector = sourceParserReflector;
        this.metaAnnotationArranger = metaAnnotationArranger;
        this.metaTypeNameAdjuster = metaTypeNameAdjuster;
        this.nativeDataTypeProvider = nativeDataTypeProvider;
        this.formFieldNameAdjuster = formFieldNameAdjuster;
    }

    public TypeDocMeta analyzeReturnClass(Method method) {
        TypeDocMeta returnDocMeta = new TypeDocMeta();
        returnDocMeta.setType(method.getReturnType());
        returnDocMeta.setTypeName(this.adjustTypeName(method.getGenericReturnType()));
        returnDocMeta.setSimpleTypeName(this.adjustSimpleTypeName(method.getGenericReturnType()));
        returnDocMeta.setGenericType(DfReflectionUtil.getGenericFirstClass((Type)method.getGenericReturnType()));
        returnDocMeta.setAnnotationTypeList(Arrays.asList(method.getAnnotatedReturnType().getAnnotations()));
        returnDocMeta.setAnnotationList(this.metaAnnotationArranger.arrangeAnnotationList(returnDocMeta.getAnnotationTypeList()));
        this.derivedManualReturnClass(method, returnDocMeta);
        Class<?> returnClass = returnDocMeta.getGenericType();
        if (returnClass != null) {
            LinkedHashMap genericParameterTypesMap = DfCollectionUtil.newLinkedHashMap();
            Type[] parameterTypes = DfReflectionUtil.getGenericParameterTypes((Type)method.getGenericReturnType());
            TypeVariable[] typeVariables = returnClass.getTypeParameters();
            IntStream.range(0, parameterTypes.length).forEach(parameterTypesIndex -> {
                Type[] genericParameterTypes = DfReflectionUtil.getGenericParameterTypes((Type)parameterTypes[parameterTypesIndex]);
                IntStream.range(0, typeVariables.length).forEach(typeVariablesIndex -> {
                    Type type = genericParameterTypes[typeVariablesIndex];
                    genericParameterTypesMap.put(typeVariables[typeVariablesIndex].getTypeName(), type);
                });
            });
            if (Iterable.class.isAssignableFrom(returnClass)) {
                returnClass = LaDocReflectionUtil.extractElementType(method.getGenericReturnType(), 1);
            }
            List<Class<?>> nativeClassList = this.nativeDataTypeProvider.provideNativeDataTypeList();
            if (returnClass != null && !nativeClassList.contains(returnClass)) {
                List<TypeDocMeta> propertyDocMetaList = this.analyzeProperties(Collections.unmodifiableMap(genericParameterTypesMap), returnClass);
                returnDocMeta.setNestTypeDocMetaList(propertyDocMetaList);
            }
            if (this.sourceParserReflector.isPresent()) {
                ((SourceParserReflector)this.sourceParserReflector.get()).reflect(returnDocMeta, returnClass);
            }
        }
        return returnDocMeta;
    }

    protected void derivedManualReturnClass(Method method, TypeDocMeta returnDocMeta) {
    }

    protected List<TypeDocMeta> analyzeProperties(Map<String, Type> genericParameterTypesMap, Class<?> propertyOwner) {
        ActionPropertiesAnalyzer propertiesAnalyzer = this.createActionPropertiesAnalyzer(genericParameterTypesMap);
        return propertiesAnalyzer.analyzeProperties(propertyOwner, this.depth);
    }

    protected ActionPropertiesAnalyzer createActionPropertiesAnalyzer(Map<String, Type> genericParameterTypesMap) {
        return new ActionPropertiesAnalyzer(this.sourceParserReflector, genericParameterTypesMap, this.metaAnnotationArranger, this.metaTypeNameAdjuster, this.formFieldNameAdjuster);
    }

    protected String adjustTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustTypeName(type);
    }

    protected String adjustTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustTypeName(typeName);
    }

    protected String adjustSimpleTypeName(Type type) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(type);
    }

    protected String adjustSimpleTypeName(String typeName) {
        return this.metaTypeNameAdjuster.adjustSimpleTypeName(typeName);
    }
}

