/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.infra.maven;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.dbflute.optional.OptionalThing;

public class MavenVersionFinder {
    public OptionalThing<String> findVersion(String groupId, String artifactId) {
        String version;
        String propPath;
        block14: {
            propPath = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
            version = null;
            try {
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(propPath);
                if (!urls.hasMoreElements()) break block14;
                URL url = urls.nextElement();
                try (InputStream is = url.openStream();){
                    Properties props = new Properties();
                    props.load(is);
                    version = props.getProperty("version");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return OptionalThing.ofNullable(version, () -> {
            String msg = "Not found the version in maven: path=" + propPath;
            throw new IllegalStateException(msg);
        });
    }
}

