/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.sourceparser.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.docmeta.JobDocMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.sourceparser.SourceParserReflector;
import org.lastaflute.meta.sourceparser.javaparser.assist.JavaparserMethodIdentityDeterminer;
import org.lastaflute.meta.sourceparser.javaparser.parsing.JavaparserSourceMethodHandler;
import org.lastaflute.meta.sourceparser.javaparser.parsing.JavaparserSourceTypeHandler;
import org.lastaflute.meta.sourceparser.javaparser.visiting.JavaparserActionDocMetaVisitorAdapter;

public class JavaparserSourceParserReflector
implements SourceParserReflector {
    protected static final Pattern CLASS_METHOD_COMMENT_END_PATTERN = Pattern.compile("(.+)[.\u3002]?.*(\r?\n)?");
    protected static final Pattern FIELD_COMMENT_END_PATTERN = Pattern.compile("([^.\u3002\\*]+).* ?\\*?");
    protected final JavaparserMethodIdentityDeterminer methodIdentityDeterminer = this.newJavaparserMethodIdentityDeterminer();
    protected final JavaparserSourceTypeHandler sourceTypeHandler;
    protected final JavaparserSourceMethodHandler sourceMethodHandler;

    public JavaparserSourceParserReflector(List<String> srcDirList) {
        this.sourceTypeHandler = this.newJavaparserSourceTypeHandler(srcDirList);
        this.sourceMethodHandler = this.newJavaparserSourceMethodHandler(this.sourceTypeHandler, this.methodIdentityDeterminer);
    }

    protected JavaparserMethodIdentityDeterminer newJavaparserMethodIdentityDeterminer() {
        return new JavaparserMethodIdentityDeterminer();
    }

    protected JavaparserSourceTypeHandler newJavaparserSourceTypeHandler(List<String> srcDirList) {
        return new JavaparserSourceTypeHandler(srcDirList);
    }

    protected JavaparserSourceMethodHandler newJavaparserSourceMethodHandler(JavaparserSourceTypeHandler sourceTypeHandler, JavaparserMethodIdentityDeterminer methodIdentityDeterminer) {
        return new JavaparserSourceMethodHandler(sourceTypeHandler, methodIdentityDeterminer);
    }

    @Override
    public List<Method> getMethodListOrderByDefinition(Class<?> clazz) {
        return this.sourceMethodHandler.getMethodListOrderByDefinition(clazz);
    }

    @Override
    public void reflect(ActionDocMeta meta, Method method) {
        this.parseClass(method.getDeclaringClass()).ifPresent(compilationUnit -> {
            LinkedHashMap returnMap = DfCollectionUtil.newLinkedHashMap();
            VoidVisitorAdapter<ActionDocMeta> adapter = this.createActionDocMetaVisitorAdapter(method, returnMap);
            adapter.visit(compilationUnit, (Object)meta);
            ArrayList descriptionList = DfCollectionUtil.newArrayList();
            Arrays.asList(meta.getTypeComment(), meta.getMethodComment()).forEach(comment -> {
                Matcher matcher;
                if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment) && (matcher = CLASS_METHOD_COMMENT_END_PATTERN.matcher((CharSequence)comment)).find()) {
                    descriptionList.add(matcher.group(1));
                }
            });
            if (!descriptionList.isEmpty()) {
                meta.setDescription(String.join((CharSequence)", ", descriptionList));
            }
            List<TypeDocMeta> parameterTypeDocMetaList = meta.getParameterTypeDocMetaList();
            Parameter[] parameters = method.getParameters();
            for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
                if (parameterIndex >= parameterTypeDocMetaList.size()) continue;
                Parameter parameter = parameters[parameterIndex];
                TypeDocMeta typeDocMeta = parameterTypeDocMetaList.get(parameterIndex);
                meta.setUrl(meta.getUrl().replace("{" + parameter.getName() + "}", "{" + typeDocMeta.getName() + "}"));
            }
            String methodName = method.getName();
            if (returnMap.containsKey(methodName) && !((List)returnMap.get(methodName)).isEmpty()) {
                meta.getReturnTypeDocMeta().setValue(String.join((CharSequence)",", (Iterable)returnMap.get(methodName)));
            }
        });
    }

    protected VoidVisitorAdapter<ActionDocMeta> createActionDocMetaVisitorAdapter(Method method, Map<String, List<String>> returnMap) {
        return new JavaparserActionDocMetaVisitorAdapter(method, returnMap, nodeWithJavadoc -> this.adjustComment((NodeWithJavadoc<?>)nodeWithJavadoc), this.methodIdentityDeterminer);
    }

    @Override
    public void reflect(JobDocMeta jobDocMeta, Class<?> clazz) {
        this.parseClass(clazz).ifPresent(compilationUnit -> {
            VoidVisitorAdapter<JobDocMeta> adapter = this.createJobDocMetaVisitorAdapter();
            adapter.visit(compilationUnit, (Object)jobDocMeta);
            ArrayList descriptionList = DfCollectionUtil.newArrayList();
            Arrays.asList(jobDocMeta.getTypeComment(), jobDocMeta.getMethodComment()).forEach(comment -> {
                Matcher matcher;
                if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment) && (matcher = CLASS_METHOD_COMMENT_END_PATTERN.matcher((CharSequence)comment)).find()) {
                    descriptionList.add(matcher.group(1));
                }
            });
            if (!descriptionList.isEmpty()) {
                jobDocMeta.setDescription(String.join((CharSequence)", ", descriptionList));
            }
        });
    }

    protected VoidVisitorAdapter<JobDocMeta> createJobDocMetaVisitorAdapter() {
        return new JobDocMetaVisitorAdapter();
    }

    @Override
    public void reflect(TypeDocMeta typeDocMeta, Class<?> clazz) {
        ArrayList classList = DfCollectionUtil.newArrayList();
        for (Class<?> targetClass2 = clazz; targetClass2 != null; targetClass2 = targetClass2.getSuperclass()) {
            if (targetClass2.isPrimitive() || Number.class.isAssignableFrom(targetClass2) || Arrays.asList(Object.class, String.class).contains(targetClass2)) continue;
            classList.add(targetClass2);
        }
        Collections.reverse(classList);
        classList.forEach(targetClass -> this.parseClass((Class<?>)targetClass).ifPresent(compilationUnit -> {
            VoidVisitorAdapter<TypeDocMeta> adapter = this.createTypeDocMetaVisitorAdapter(clazz);
            adapter.visit(compilationUnit, (Object)typeDocMeta);
        }));
    }

    protected VoidVisitorAdapter<TypeDocMeta> createTypeDocMetaVisitorAdapter(Class<?> clazz) {
        return new TypeDocMetaVisitorAdapter(clazz);
    }

    protected String adjustComment(NodeWithJavadoc<?> nodeWithJavadoc) {
        try {
            return nodeWithJavadoc.getJavadoc().map(javadoc -> javadoc.toText().replaceAll("(^\r?\n|\r?\n$)", "")).orElse(null);
        }
        catch (Throwable t) {
            return "javadoc parse error. error messge=" + t.getMessage();
        }
    }

    protected OptionalThing<CompilationUnit> parseClass(Class<?> clazz) {
        return this.sourceTypeHandler.parseClass(clazz);
    }

    public class TypeDocMetaVisitorAdapter
    extends VoidVisitorAdapter<TypeDocMeta> {
        private Class<?> clazz;

        public TypeDocMetaVisitorAdapter(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, TypeDocMeta typeDocMeta) {
            this.prepareClassComment(classOrInterfaceDeclaration, typeDocMeta);
            super.visit(classOrInterfaceDeclaration, (Object)typeDocMeta);
        }

        protected void prepareClassComment(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, TypeDocMeta typeDocMeta) {
            String comment;
            if (DfStringUtil.is_Null_or_Empty((String)typeDocMeta.getComment()) && classOrInterfaceDeclaration.getNameAsString().equals(typeDocMeta.getSimpleTypeName()) && DfStringUtil.is_NotNull_and_NotEmpty((String)(comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)classOrInterfaceDeclaration)))) {
                typeDocMeta.setComment(comment);
                Matcher matcher = CLASS_METHOD_COMMENT_END_PATTERN.matcher(comment);
                if (matcher.find()) {
                    typeDocMeta.setDescription(matcher.group(1));
                }
            }
        }

        public void visit(FieldDeclaration fieldDeclaration, TypeDocMeta typeDocMeta) {
            this.prepareFieldComment(fieldDeclaration, typeDocMeta);
            super.visit(fieldDeclaration, (Object)typeDocMeta);
        }

        protected void prepareFieldComment(FieldDeclaration fieldDeclaration, TypeDocMeta typeDocMeta) {
            String comment;
            if (fieldDeclaration.getVariables().stream().anyMatch(variable -> variable.getNameAsString().equals(typeDocMeta.getName())) && DfStringUtil.is_NotNull_and_NotEmpty((String)(comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)fieldDeclaration))) && (DfStringUtil.is_Null_or_Empty((String)typeDocMeta.getComment()) || fieldDeclaration.getParentNode().map(parentNode -> {
                TypeDeclaration typeDeclaration = (TypeDeclaration)parentNode;
                return typeDeclaration.getNameAsString().equals(this.clazz.getSimpleName());
            }).orElse(false).booleanValue())) {
                typeDocMeta.setComment(comment);
                Matcher matcher = FIELD_COMMENT_END_PATTERN.matcher(this.saveFieldCommentSpecialExp(comment));
                if (matcher.find()) {
                    String description = matcher.group(1).trim();
                    typeDocMeta.setDescription(this.restoreFieldCommentSpecialExp(description));
                }
            }
        }

        protected String saveFieldCommentSpecialExp(String comment) {
            return comment.replace("e.g.", "$$edotgdot$$");
        }

        protected String restoreFieldCommentSpecialExp(String comment) {
            return comment.replace("$$edotgdot$$", "e.g.");
        }
    }

    public class JobDocMetaVisitorAdapter
    extends VoidVisitorAdapter<JobDocMeta> {
        public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, JobDocMeta jobDocMeta) {
            classOrInterfaceDeclaration.getBegin().ifPresent(begin -> classOrInterfaceDeclaration.getEnd().ifPresent(end -> jobDocMeta.setFileLineCount(end.line - begin.line)));
            String comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)classOrInterfaceDeclaration);
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
                jobDocMeta.setTypeComment(comment);
            }
            super.visit(classOrInterfaceDeclaration, (Object)jobDocMeta);
        }

        public void visit(MethodDeclaration methodDeclaration, JobDocMeta jobDocMeta) {
            if (!methodDeclaration.getNameAsString().equals(jobDocMeta.getMethodName())) {
                return;
            }
            methodDeclaration.getBegin().ifPresent(begin -> methodDeclaration.getEnd().ifPresent(end -> jobDocMeta.setMethodLineCount(end.line - begin.line)));
            String comment = JavaparserSourceParserReflector.this.adjustComment((NodeWithJavadoc<?>)methodDeclaration);
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
                jobDocMeta.setMethodComment(comment);
            }
            super.visit(methodDeclaration, (Object)jobDocMeta);
        }
    }
}

