/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.sourceparser.javaparser.assist;

import com.github.javaparser.ast.body.MethodDeclaration;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dbflute.util.Srl;

public class JavaparserMethodIdentityDeterminer {
    public boolean matchesMethod(Method method, MethodDeclaration dec) {
        return this.buildMethodIdentityNative(method).equals(this.buildMethodIdentitySource(dec));
    }

    public String buildMethodIdentityNative(Method method) {
        String methodName = method.getName();
        String paramExp = Stream.of(method.getParameters()).map(pr -> pr.getType().getSimpleName()).collect(Collectors.joining(this.getParameterDelimiter()));
        return this.doBuildMethodIdentity(methodName, paramExp);
    }

    public String buildMethodIdentitySource(MethodDeclaration dec) {
        String methodName = dec.getNameAsString();
        String paramExp = dec.getParameters().stream().map(pr -> {
            String plainExp = pr.getTypeAsString();
            return this.filterSourceParamExpIfNeeds(plainExp);
        }).collect(Collectors.joining(this.getParameterDelimiter()));
        return this.doBuildMethodIdentity(methodName, paramExp);
    }

    protected String filterSourceParamExpIfNeeds(String oneParamExp) {
        return this.removeCDefPrefixIfNeeds(this.removeGenericDefinitionIfNeeds(oneParamExp));
    }

    protected String removeGenericDefinitionIfNeeds(String oneParamExp) {
        return Srl.substringFirstFront((String)oneParamExp, (String[])new String[]{"<"});
    }

    protected String removeCDefPrefixIfNeeds(String oneParamExp) {
        if (oneParamExp.contains("CDef.")) {
            return Srl.substringFirstRear((String)oneParamExp, (String[])new String[]{"CDef."});
        }
        return oneParamExp;
    }

    protected String getParameterDelimiter() {
        return ", ";
    }

    protected String doBuildMethodIdentity(String methodName, String paramExp) {
        return methodName + "(" + paramExp + ")";
    }
}

