/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.sourceparser.javaparser.parsing;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.meta.sourceparser.javaparser.assist.JavaparserMethodIdentityDeterminer;
import org.lastaflute.meta.sourceparser.javaparser.parsing.JavaparserSourceTypeHandler;

public class JavaparserSourceMethodHandler {
    protected final JavaparserSourceTypeHandler sourceTypeHandler;
    protected final JavaparserMethodIdentityDeterminer methodIdentityDeterminer;

    public JavaparserSourceMethodHandler(JavaparserSourceTypeHandler sourceTypeHandler, JavaparserMethodIdentityDeterminer methodIdentityDeterminer) {
        this.sourceTypeHandler = sourceTypeHandler;
        this.methodIdentityDeterminer = methodIdentityDeterminer;
    }

    public List<Method> getMethodListOrderByDefinition(Class<?> clazz) {
        ArrayList nativeMethodList = DfCollectionUtil.newArrayList((Object[])clazz.getMethods());
        this.orderMethodListBySource(clazz, nativeMethodList);
        return nativeMethodList;
    }

    protected void orderMethodListBySource(Class<?> clazz, List<Method> nativeMethodList) {
        List sourceIdentityList = this.extractMethodDeclarationList(clazz).stream().map(dec -> this.buildMethodIdentitySource((MethodDeclaration)dec)).collect(Collectors.toList());
        DfCollectionUtil.AccordingToOrderResource resource = new DfCollectionUtil.AccordingToOrderResource();
        resource.setupResource(sourceIdentityList, method -> this.buildMethodIdentityNative((Method)method));
        DfCollectionUtil.orderAccordingTo(nativeMethodList, (DfCollectionUtil.AccordingToOrderResource)resource);
    }

    protected String buildMethodIdentityNative(Method method) {
        return this.methodIdentityDeterminer.buildMethodIdentityNative(method);
    }

    protected String buildMethodIdentitySource(MethodDeclaration dec) {
        return this.methodIdentityDeterminer.buildMethodIdentitySource(dec);
    }

    protected List<MethodDeclaration> extractMethodDeclarationList(Class<?> clazz) {
        final ArrayList methodDeclarationList = DfCollectionUtil.newArrayList();
        this.sourceTypeHandler.parseClass(clazz).ifPresent(compilationUnit -> {
            VoidVisitorAdapter<Void> adapter = new VoidVisitorAdapter<Void>(){

                public void visit(MethodDeclaration methodDeclaration, Void arg) {
                    methodDeclarationList.add(methodDeclaration);
                    super.visit(methodDeclaration, (Object)arg);
                }
            };
            adapter.visit(compilationUnit, null);
        });
        return methodDeclarationList;
    }
}

