/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.sourceparser.javaparser.parsing;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;

public class JavaparserSourceTypeHandler {
    protected static final Map<String, CachedCompilationUnit> cachedCompilationUnitMap = DfCollectionUtil.newHashMap();
    protected final List<String> srcDirList;

    public JavaparserSourceTypeHandler(List<String> srcDirList) {
        this.srcDirList = srcDirList;
    }

    public OptionalThing<CompilationUnit> parseClass(Class<?> clazz) {
        JavaParser javaParser = new JavaParser();
        for (String srcDir : this.srcDirList) {
            CachedCompilationUnit cachedCompilationUnit;
            File file = new File(srcDir, clazz.getName().replace('.', File.separatorChar) + ".java");
            if (!file.exists() && !(file = new File(srcDir, clazz.getName().replace('.', File.separatorChar).replaceAll("\\$.*", "") + ".java")).exists()) continue;
            if (cachedCompilationUnitMap.containsKey(clazz.getName()) && (cachedCompilationUnit = cachedCompilationUnitMap.get(clazz.getName())) != null && cachedCompilationUnit.fileLastModified == file.lastModified() && cachedCompilationUnit.fileLength == file.length()) {
                return OptionalThing.of((Object)cachedCompilationUnit.compilationUnit);
            }
            cachedCompilationUnit = new CachedCompilationUnit();
            cachedCompilationUnit.fileLastModified = file.lastModified();
            cachedCompilationUnit.fileLength = file.length();
            try {
                ParseResult parse = javaParser.parse(file);
                parse.getResult().ifPresent(compilationUnit -> cachedCompilationUnit.compilationUnit = compilationUnit);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Source file don't exist.");
            }
            cachedCompilationUnitMap.put(clazz.getName(), cachedCompilationUnit);
            return OptionalThing.of((Object)cachedCompilationUnit.compilationUnit);
        }
        return OptionalThing.ofNullable(null, () -> {
            throw new IllegalStateException("Source file don't exist.");
        });
    }

    private static class CachedCompilationUnit {
        private long fileLastModified;
        private long fileLength;
        private CompilationUnit compilationUnit;

        private CachedCompilationUnit() {
        }
    }
}

