/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.sourceparser.javaparser.visiting;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.sourceparser.javaparser.assist.JavaparserMethodIdentityDeterminer;

public class JavaparserActionDocMetaVisitorAdapter
extends VoidVisitorAdapter<ActionDocMeta> {
    protected static final Pattern RETURN_STMT_PATTERN = Pattern.compile("^[^)]+\\)");
    protected final Method method;
    protected final Map<String, List<String>> returnMap;
    protected final Function<NodeWithJavadoc<?>, String> commentAdjuster;
    protected final JavaparserMethodIdentityDeterminer methodIdentityDeterminer;

    public JavaparserActionDocMetaVisitorAdapter(Method method, Map<String, List<String>> returnMap, Function<NodeWithJavadoc<?>, String> commentAdjuster, JavaparserMethodIdentityDeterminer methodIdentityDeterminer) {
        this.method = method;
        this.returnMap = returnMap;
        this.commentAdjuster = commentAdjuster;
        this.methodIdentityDeterminer = methodIdentityDeterminer;
    }

    public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, ActionDocMeta actionDocMeta) {
        classOrInterfaceDeclaration.getBegin().ifPresent(begin -> classOrInterfaceDeclaration.getEnd().ifPresent(end -> actionDocMeta.setFileLineCount(end.line - begin.line)));
        String comment = this.commentAdjuster.apply((NodeWithJavadoc<?>)classOrInterfaceDeclaration);
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
            actionDocMeta.setTypeComment(comment);
        }
        super.visit(classOrInterfaceDeclaration, (Object)actionDocMeta);
    }

    public void visit(final MethodDeclaration methodDeclaration, ActionDocMeta actionDocMeta) {
        if (!this.matchesMethod(methodDeclaration)) {
            return;
        }
        methodDeclaration.getBegin().ifPresent(begin -> methodDeclaration.getEnd().ifPresent(end -> actionDocMeta.setMethodLineCount(end.line - begin.line)));
        String comment = this.commentAdjuster.apply((NodeWithJavadoc<?>)methodDeclaration);
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment)) {
            actionDocMeta.setMethodComment(comment);
        }
        IntStream.range(0, actionDocMeta.getParameterTypeDocMetaList().size()).forEach(parameterIndex -> {
            if (parameterIndex < methodDeclaration.getParameters().size()) {
                Pattern pattern;
                Matcher matcher;
                TypeDocMeta typeDocMeta = actionDocMeta.getParameterTypeDocMetaList().get(parameterIndex);
                Parameter parameter = (Parameter)methodDeclaration.getParameters().get(parameterIndex);
                typeDocMeta.setName(parameter.getNameAsString());
                typeDocMeta.setPublicName(parameter.getNameAsString());
                if (DfStringUtil.is_NotNull_and_NotEmpty((String)comment) && (matcher = (pattern = Pattern.compile(".*@param\\s?" + parameter.getNameAsString() + "\\s?(.*)\r?\n.*", 32)).matcher(comment)).matches()) {
                    typeDocMeta.setComment(matcher.group(1).replaceAll("\r?\n.*", ""));
                    typeDocMeta.setDescription(typeDocMeta.getComment().replaceAll(" ([^\\p{Alnum}]|e\\.g\\. )+.*", ""));
                }
            }
        });
        methodDeclaration.accept((VoidVisitor)new VoidVisitorAdapter<ActionDocMeta>(){

            public void visit(ReturnStmt returnStmt, ActionDocMeta actionDocMeta) {
                JavaparserActionDocMetaVisitorAdapter.this.prepareReturnStmt(methodDeclaration, returnStmt);
                super.visit(returnStmt, (Object)actionDocMeta);
            }
        }, (Object)actionDocMeta);
        super.visit(methodDeclaration, (Object)actionDocMeta);
    }

    protected boolean matchesMethod(MethodDeclaration methodDeclaration) {
        return this.methodIdentityDeterminer.matchesMethod(this.method, methodDeclaration);
    }

    protected void prepareReturnStmt(MethodDeclaration methodDeclaration, ReturnStmt returnStmt) {
        returnStmt.getExpression().ifPresent(expression -> {
            String returnStmtStr = expression.toString();
            Matcher matcher = RETURN_STMT_PATTERN.matcher(returnStmtStr);
            if (!this.returnMap.containsKey(methodDeclaration.getNameAsString())) {
                this.returnMap.put(methodDeclaration.getNameAsString(), DfCollectionUtil.newArrayList());
            }
            this.returnMap.get(methodDeclaration.getNameAsString()).add(matcher.find() ? matcher.group(0) : "##unanalyzable##");
        });
    }
}

