/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.Srl;
import org.lastaflute.meta.exception.LastaMetaIOException;
import org.lastaflute.meta.swagger.diff.SwaggerDiffOption;
import org.lastaflute.meta.swagger.diff.node.SwaggerDiffNodePathFilter;
import org.lastaflute.meta.swagger.diff.node.SwaggerDiffNodeTargeting;
import org.openapitools.openapidiff.core.OpenApiCompare;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;

public class SwaggerDiff {
    protected final SwaggerDiffOption swaggerDiffOption;
    protected final SwaggerDiffNodeTargeting nodeTargeting = this.newSwaggerDiffNodeTargeting();

    protected SwaggerDiffNodeTargeting newSwaggerDiffNodeTargeting() {
        return new SwaggerDiffNodeTargeting();
    }

    public SwaggerDiff() {
        this(op -> {});
    }

    public SwaggerDiff(Consumer<SwaggerDiffOption> opLambda) {
        this.swaggerDiffOption = this.createSwaggerDiffOption(opLambda);
    }

    protected SwaggerDiffOption createSwaggerDiffOption(Consumer<SwaggerDiffOption> opLambda) {
        SwaggerDiffOption swaggerDiffOption = new SwaggerDiffOption();
        opLambda.accept(swaggerDiffOption);
        return swaggerDiffOption;
    }

    public String diffFromLocations(String leftSwaggerLocation, String rightSwaggerLocation) {
        try {
            ChangedOpenApi changedOpenApi = this.doDiffFromLocationsInChangedOpenApi(leftSwaggerLocation, rightSwaggerLocation);
            return this.swaggerDiffOption.getDiffResultRender().render(changedOpenApi);
        }
        catch (RuntimeException e) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Failed to diff the swagger files.");
            br.addItem("leftSwaggerLocation");
            br.addElement((Object)leftSwaggerLocation);
            br.addItem("rightSwaggerLocation");
            br.addElement((Object)rightSwaggerLocation);
            String msg = br.buildExceptionMessage();
            throw new IllegalStateException(msg, e);
        }
    }

    public String diffFromContents(String leftSwaggerContent, String rightSwaggerContent) {
        ChangedOpenApi changedOpenApi = this.diffFromContentsInChangedOpenApi(leftSwaggerContent, rightSwaggerContent);
        String value = this.swaggerDiffOption.getDiffResultRender().render(changedOpenApi);
        return value;
    }

    /*
     * Exception decompiling
     */
    protected ChangedOpenApi doDiffFromLocationsInChangedOpenApi(String leftSwaggerLocation, String rightSwaggerLocation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ChangedOpenApi diffFromContentsInChangedOpenApi(String leftSwaggerContent, String rightSwaggerContent) {
        String leftParsedContent = this.prepareParsedContent(leftSwaggerContent, this.swaggerDiffOption.getLeftContentFilter());
        String rightParsedContent = this.prepareParsedContent(rightSwaggerContent, this.swaggerDiffOption.getRightContentFilter());
        OpenAPI leftOpenAPI = this.parseOpenApiContent(leftParsedContent);
        OpenAPI rightOpenAPI = this.parseOpenApiContent(rightParsedContent);
        return this.compareOpenAPILeftRight(leftOpenAPI, rightOpenAPI);
    }

    protected String prepareParsedContent(String swaggerContent, OptionalThing<Function<String, String>> contentFilter) {
        String firstFiltered = (String)contentFilter.map(filter -> (String)filter.apply(swaggerContent)).orElse((Object)swaggerContent);
        return this.resolveSwaggerContentNode(firstFiltered);
    }

    protected String resolveSwaggerContentNode(String swaggerContent) {
        try {
            String encoding = this.getSwaggerDiffOption().getSwaggerContentCharset().name();
            String decoded = this.decodeContent(swaggerContent, encoding);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(decoded);
            this.filterPathIfNeeds(rootNode);
            this.selectTargetNode(rootNode);
            return objectMapper.writeValueAsString((Object)rootNode);
        }
        catch (IOException e) {
            this.throwSwaggerDiffContentReadIOException(swaggerContent, e);
            return null;
        }
    }

    protected String decodeContent(String swaggerContent, String encoding) throws UnsupportedEncodingException {
        String filtered = swaggerContent;
        filtered = Srl.replace((String)filtered, (String)"%24", (String)"$");
        filtered = Srl.replace((String)filtered, (String)"%3C", (String)"<");
        filtered = Srl.replace((String)filtered, (String)"%3E", (String)">");
        filtered = Srl.replace((String)filtered, (String)"%40", (String)"@");
        return filtered;
    }

    protected void filterPathIfNeeds(JsonNode rootNode) {
        SwaggerDiffOption option = this.getSwaggerDiffOption();
        SwaggerDiffNodePathFilter filter = new SwaggerDiffNodePathFilter();
        if (option.isPathTrailingSlashIgnored()) {
            filter.deletePathTrailingSlash();
        }
        List<String> exceptedPathPrefixList = option.getExceptedPathPrefixList();
        for (String pathPrefix : exceptedPathPrefixList) {
            filter.exceptPathByPrefix(pathPrefix);
        }
        List<String> exceptedPathResponseContentTypeList = option.getExceptedPathResponseContentTypeList();
        for (String contentType : exceptedPathResponseContentTypeList) {
            filter.exceptPathByResponseContentType(contentType);
        }
        filter.filterPathIfNeeds(rootNode);
    }

    protected void selectTargetNode(JsonNode rootNode) {
        this.nodeTargeting.prepareNodeTargeting(this.getSwaggerDiffOption().getTargetNodeLambda()).accept("", rootNode);
    }

    protected void throwSwaggerDiffContentReadIOException(String swaggerContent, IOException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to parse the swagger");
        br.addItem("swaggerContent");
        br.addElement((Object)swaggerContent);
        String msg = br.buildExceptionMessage();
        throw new LastaMetaIOException(msg, e);
    }

    protected OpenAPI parseOpenApiContent(String leftParsedContent) {
        return new OpenAPIParser().readContents(leftParsedContent, null, null).getOpenAPI();
    }

    protected ChangedOpenApi compareOpenAPILeftRight(OpenAPI leftOpenAPI, OpenAPI rightOpenAPI) {
        return OpenApiCompare.fromSpecifications((OpenAPI)leftOpenAPI, (OpenAPI)rightOpenAPI);
    }

    protected InputStream getInputStream(String location) {
        try {
            if (location.contains(":")) {
                return new URL(location).openStream();
            }
            InputStream inputStream = this.getClass().getResourceAsStream(location);
            if (inputStream != null) {
                return inputStream;
            }
            return new FileInputStream(location);
        }
        catch (IOException e) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Failed to read location");
            br.addItem("location");
            br.addElement((Object)location);
            String msg = br.buildExceptionMessage();
            throw new LastaMetaIOException(msg, e);
        }
    }

    protected SwaggerDiffOption getSwaggerDiffOption() {
        return this.swaggerDiffOption;
    }
}

