/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.diff;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.Srl;
import org.lastaflute.meta.swagger.diff.render.LastaMetaMarkdownRender;
import org.openapitools.openapidiff.core.output.Render;

public class SwaggerDiffOption {
    protected Charset swaggerContentCharset = StandardCharsets.UTF_8;
    protected Render diffResultRender = this.newLastaMetaMarkdownRender();
    protected boolean pathTrailingSlashIgnored;
    protected final List<String> exceptedPathPrefixList = new ArrayList<String>();
    protected final List<String> exceptedPathResponseContentTypeList = new ArrayList<String>();
    protected Function<String, String> leftContentFilter;
    protected Function<String, String> rightContentFilter;
    protected BiPredicate<String, String> targetNodeLambda = this.prepareDefaultTargetItem();

    protected LastaMetaMarkdownRender newLastaMetaMarkdownRender() {
        return new LastaMetaMarkdownRender();
    }

    protected BiPredicate<String, String> prepareDefaultTargetItem() {
        return (path, name) -> {
            if (DfCollectionUtil.newArrayList((Object[])new String[]{"summary", "description", "examples"}).contains(name)) {
                return false;
            }
            if (path.matches(".+\\.responses\\.[^.]+$")) {
                return Srl.isNumberHarfAll((String)name) && name.startsWith("2") && name.length() == 3;
            }
            return true;
        };
    }

    public void setSwaggerContentCharset(Charset swaggerContentCharset) {
        if (swaggerContentCharset == null) {
            throw new IllegalArgumentException("The argument 'swaggerContentCharset' should not be null.");
        }
        this.swaggerContentCharset = swaggerContentCharset;
    }

    public void setDiffResultRender(Render diffResultRender) {
        if (diffResultRender == null) {
            throw new IllegalArgumentException("The argument 'diffResultRender' should not be null.");
        }
        this.diffResultRender = diffResultRender;
    }

    public SwaggerDiffOption ignorePathTrailingSlash() {
        this.pathTrailingSlashIgnored = true;
        return this;
    }

    public SwaggerDiffOption exceptPathByPrefix(String pathPrefix) {
        if (pathPrefix == null) {
            throw new IllegalArgumentException("The argument 'pathPrefix' should not be null.");
        }
        this.exceptedPathPrefixList.add(pathPrefix);
        return this;
    }

    public SwaggerDiffOption exceptPathResponseContentType(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("The argument 'contentType' should not be null.");
        }
        this.exceptedPathResponseContentTypeList.add(contentType);
        return this;
    }

    public SwaggerDiffOption filterLeftContent(Function<String, String> leftContentFilter) {
        if (leftContentFilter == null) {
            throw new IllegalArgumentException("The argument 'leftContentFilter' should not be null.");
        }
        this.leftContentFilter = leftContentFilter;
        return this;
    }

    public SwaggerDiffOption filterRightContent(Function<String, String> rightContentFilter) {
        if (rightContentFilter == null) {
            throw new IllegalArgumentException("The argument 'rightContentFilter' should not be null.");
        }
        this.rightContentFilter = rightContentFilter;
        return this;
    }

    public void deriveTargetNodeAnd(BiPredicate<String, String> targetNodeLambda) {
        if (targetNodeLambda == null) {
            throw new IllegalArgumentException("The argument 'targetNodeLambda' should not be null.");
        }
        this.targetNodeLambda = this.targetNodeLambda.and(targetNodeLambda);
    }

    public void switchTargetNodeDeterminer(BiPredicate<String, String> targetNodeLambda) {
        if (targetNodeLambda == null) {
            throw new IllegalArgumentException("The argument 'targetNodeLambda' should not be null.");
        }
        this.targetNodeLambda = targetNodeLambda;
    }

    public Charset getSwaggerContentCharset() {
        return this.swaggerContentCharset;
    }

    public Render getDiffResultRender() {
        return this.diffResultRender;
    }

    public boolean isPathTrailingSlashIgnored() {
        return this.pathTrailingSlashIgnored;
    }

    public List<String> getExceptedPathPrefixList() {
        return Collections.unmodifiableList(this.exceptedPathPrefixList);
    }

    public List<String> getExceptedPathResponseContentTypeList() {
        return Collections.unmodifiableList(this.exceptedPathResponseContentTypeList);
    }

    public OptionalThing<Function<String, String>> getLeftContentFilter() {
        return OptionalThing.ofNullable(this.leftContentFilter, () -> {
            throw new IllegalStateException("Not found the leftContentFilter.");
        });
    }

    public OptionalThing<Function<String, String>> getRightContentFilter() {
        return OptionalThing.ofNullable(this.rightContentFilter, () -> {
            throw new IllegalStateException("Not found the rightContentFilter.");
        });
    }

    public BiPredicate<String, String> getTargetNodeLambda() {
        return this.targetNodeLambda;
    }
}

