/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.diff.node;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dbflute.util.Srl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerDiffNodePathFilter {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerDiffNodePathFilter.class);
    protected boolean pathTrailingSlashDeleted;
    protected final List<String> exceptedPathPrefixList = new ArrayList<String>();
    protected final List<String> exceptedPathResponseContentTypeList = new ArrayList<String>();

    public SwaggerDiffNodePathFilter deletePathTrailingSlash() {
        this.pathTrailingSlashDeleted = true;
        return this;
    }

    public SwaggerDiffNodePathFilter exceptPathByPrefix(String pathPrefix) {
        this.exceptedPathPrefixList.add(pathPrefix);
        return this;
    }

    public SwaggerDiffNodePathFilter exceptPathByResponseContentType(String contentType) {
        this.exceptedPathResponseContentTypeList.add(contentType);
        return this;
    }

    protected boolean needsFiltering() {
        return this.pathTrailingSlashDeleted || !this.exceptedPathPrefixList.isEmpty() || !this.exceptedPathResponseContentTypeList.isEmpty();
    }

    public void filterPathIfNeeds(JsonNode rootNode) {
        if (!this.needsFiltering()) {
            return;
        }
        JsonNode foundNode = rootNode.findValue("paths");
        if (foundNode == null || !foundNode.isObject()) {
            logger.debug("Not found the 'paths' node so cannot remove HTML/Stream path: foundNode=" + foundNode);
            return;
        }
        ObjectNode pathsNode = (ObjectNode)foundNode;
        if (pathsNode != null) {
            if (this.pathTrailingSlashDeleted) {
                this.removeTrailingSlash(pathsNode);
            }
            List<String> apiPathList = this.extractApiPathList(pathsNode);
            for (String apiPath : apiPathList) {
                JsonNode currentJsonNode = pathsNode.get(apiPath);
                if (this.isExceptPath(apiPath)) {
                    pathsNode.remove(apiPath);
                    continue;
                }
                this.doFilterPath(pathsNode, apiPath, currentJsonNode);
            }
        }
    }

    protected void doFilterPath(ObjectNode pathsNode, String apiPath, JsonNode currentJsonNode) {
        if (!(currentJsonNode instanceof ObjectNode)) {
            return;
        }
        ObjectNode currentObjNode = (ObjectNode)currentJsonNode;
        if (this.determineExceptedNode(currentObjNode)) {
            pathsNode.remove(apiPath);
        } else {
            Iterator fields = currentObjNode.fields();
            while (fields.hasNext()) {
                JsonNode nextNode = (JsonNode)((Map.Entry)fields.next()).getValue();
                this.doFilterPath(pathsNode, apiPath, nextNode);
            }
        }
    }

    protected void removeTrailingSlash(ObjectNode pathsNode) {
        List<String> apiPathList = this.extractApiPathList(pathsNode);
        for (String apiPath : apiPathList) {
            JsonNode currentNode = pathsNode.get(apiPath);
            String newPath = apiPath.endsWith("/") ? Srl.rtrim((String)apiPath, (String)"/") : apiPath;
            pathsNode.remove(apiPath);
            pathsNode.set(newPath, currentNode);
        }
    }

    protected boolean isExceptPath(String apiPath) {
        for (String pathPrefix : this.exceptedPathPrefixList) {
            if (!apiPath.startsWith(pathPrefix)) continue;
            return true;
        }
        return false;
    }

    protected boolean determineExceptedNode(ObjectNode currentObjNode) {
        return this.hasExceptedResponsesContentType(currentObjNode) || this.hasExceptedProduces(currentObjNode);
    }

    protected boolean hasExceptedResponsesContentType(ObjectNode currentObjNode) {
        JsonNode responsesJsonNode = currentObjNode.findValue("responses");
        if (responsesJsonNode == null || !responsesJsonNode.isObject()) {
            return false;
        }
        ObjectNode responseObjNode = (ObjectNode)responsesJsonNode;
        for (String contentType : this.exceptedPathResponseContentTypeList) {
            JsonNode exceptedNode = responseObjNode.findValue(contentType);
            if (exceptedNode == null) continue;
            return true;
        }
        return false;
    }

    protected boolean hasExceptedProduces(ObjectNode currentObjNode) {
        JsonNode produces = currentObjNode.findValue("produces");
        if (produces != null && produces.isArray()) {
            ArrayNode arrayNode = (ArrayNode)produces;
            Iterator elements = arrayNode.elements();
            while (elements.hasNext()) {
                JsonNode jsonNode = (JsonNode)elements.next();
                for (String contentType : this.exceptedPathResponseContentTypeList) {
                    if (!contentType.equals(jsonNode.textValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected List<String> extractApiPathList(ObjectNode pathsNode) {
        ArrayList<String> apiPathList = new ArrayList<String>();
        pathsNode.fieldNames().forEachRemaining(name -> apiPathList.add((String)name));
        return apiPathList;
    }
}

