/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.diff.render;

import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedMetadata;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedParameter;
import org.openapitools.openapidiff.core.model.ChangedParameters;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.output.MarkdownRender;

public class LastaMetaMarkdownRender
extends MarkdownRender {
    public LastaMetaMarkdownRender() {
        this.setShowChangedMetadata(true);
    }

    protected String listEndpoints(List<ChangedOperation> changedOperations) {
        if (null == changedOperations || changedOperations.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        changedOperations.stream().map(operation -> {
            String a;
            StringBuilder details = new StringBuilder();
            if (Changed.result((Changed)operation.getParameters()).isDifferent() && !(a = this.parameters(operation.getParameters())).isEmpty() && !a.equals("\n")) {
                details.append(this.titleH5("Parameters:")).append(a);
            }
            if (operation.resultRequestBody().isDifferent()) {
                details.append(this.titleH5("Request:")).append(this.metadata("Description", operation.getRequestBody().getDescription())).append(this.bodyContent(operation.getRequestBody().getContent()));
                RequestBody oldRequestBody = operation.getRequestBody().getOldRequestBody();
                RequestBody newRequestBody = operation.getRequestBody().getNewRequestBody();
                if (oldRequestBody != null && newRequestBody != null && oldRequestBody.getRequired() != newRequestBody.getRequired()) {
                    ChangedMetadata changedMetadata = new ChangedMetadata();
                    changedMetadata.setLeft(Objects.toString(oldRequestBody.getRequired()));
                    changedMetadata.setRight(Objects.toString(newRequestBody.getRequired()));
                    details.append(this.metadata("Required", changedMetadata));
                }
            }
            if (operation.resultApiResponses().isDifferent()) {
                details.append(this.titleH5("Return Type:")).append(this.responses(operation.getApiResponses()));
            }
            if (details.length() != 0) {
                details.insert(0, this.itemEndpoint(operation.getHttpMethod().toString(), operation.getPathUrl(), operation.getSummary()));
            }
            return details.toString();
        }).forEach(sb::append);
        if (sb.length() != 0) {
            sb.insert(0, this.sectionTitle("What's Changed"));
        }
        return sb.toString();
    }

    protected String parameters(ChangedParameters changedParameters) {
        List changed = changedParameters.getChanged();
        StringBuilder sb = new StringBuilder("\n");
        sb.append(this.listParameter("Added", changedParameters.getIncreased())).append(this.listParameter("Deleted", changedParameters.getMissing()));
        changed.stream().filter(param -> param.getChangedElements().stream().anyMatch(x -> x != null && !x.isChanged().isUnchanged())).map(this::itemParameter).forEach(sb::append);
        return sb.toString();
    }

    protected String itemParameter(ChangedParameter param) {
        Parameter oldParam = param.getOldParameter();
        Parameter newParam = param.getNewParameter();
        if (param.isDeprecated()) {
            return this.itemParameter("Deprecated", newParam.getName(), newParam.getIn(), newParam.getDescription());
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (param.getDescription() != null && !param.getDescription().isChanged().isUnchanged()) {
            map.put("description", oldParam.getDescription() + " -> " + newParam.getDescription());
        }
        if (param.getSchema() != null && !Objects.equals(oldParam.getSchema().getType(), newParam.getSchema().getType())) {
            map.put("type", oldParam.getSchema().getType() + " -> " + newParam.getSchema().getType());
        }
        if (param.getSchema() != null && !Objects.equals(oldParam.getSchema().getFormat(), newParam.getSchema().getFormat())) {
            map.put("format", oldParam.getSchema().getFormat() + " -> " + newParam.getSchema().getFormat());
        }
        return this.itemParameter("Changed", newParam.getName(), newParam.getIn(), map.isEmpty() ? newParam.getDescription() : ((Object)map).toString());
    }

    protected String property(int deepness, String name, ChangedSchema schema) {
        if (schema.isChanged().isUnchanged()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String type = this.type(schema.getNewSchema());
        if (schema.isChangedType()) {
            type = this.type(schema.getOldSchema()) + " -> " + this.type(schema.getNewSchema());
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (schema.getDescription() != null && !schema.getDescription().isChanged().isUnchanged()) {
            map.put("description", schema.getOldSchema().getDescription() + " -> " + schema.getNewSchema().getDescription());
        }
        if (!Objects.equals(schema.getOldSchema().getType(), schema.getNewSchema().getType())) {
            map.put("type", schema.getOldSchema().getType() + " -> " + schema.getNewSchema().getType());
        }
        if (!Objects.equals(schema.getOldSchema().getFormat(), schema.getNewSchema().getFormat())) {
            map.put("format", schema.getOldSchema().getFormat() + " -> " + schema.getNewSchema().getFormat());
        }
        sb.append(this.property(deepness, "Changed property", name, type, map.isEmpty() ? schema.getNewSchema().getDescription() : ((Object)map).toString()));
        sb.append(this.schema(++deepness, schema));
        return sb.toString();
    }

    protected String items(int deepness, ChangedSchema schema) {
        StringBuilder sb = new StringBuilder();
        String type = this.type(schema.getNewSchema());
        if (schema.isChangedType()) {
            type = this.type(schema.getOldSchema()) + " -> " + this.type(schema.getNewSchema());
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (schema.getDescription() != null && !schema.getDescription().isChanged().isUnchanged()) {
            map.put("description", schema.getOldSchema().getDescription() + " -> " + schema.getNewSchema().getDescription());
        }
        sb.append(this.items(deepness, "Changed items", type, map.isEmpty() ? schema.getNewSchema().getDescription() : ((Object)map).toString()));
        sb.append(this.schema(deepness, schema));
        return sb.toString();
    }
}

