/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.core.direction.AccessibleConfig;
import org.lastaflute.meta.SwaggerOption;
import org.lastaflute.meta.infra.maven.MavenVersionFinder;

public class SwaggerSpecCreator {
    protected final AccessibleConfig accessibleConfig;
    protected final HttpServletRequest currentRequest;

    public SwaggerSpecCreator(AccessibleConfig accessibleConfig, HttpServletRequest currentRequest) {
        this.accessibleConfig = accessibleConfig;
        this.currentRequest = currentRequest;
    }

    public Map<String, Object> createSwaggerSpecMap(SwaggerOption swaggerOption, SwaggerPathCall swaggerPathCall) {
        LinkedHashMap specMap = DfCollectionUtil.newLinkedHashMap();
        specMap.put("swagger", "2.0");
        specMap.put("info", this.createSwaggerInfoMap());
        specMap.put("schemes", this.prepareSwaggerMapSchemes());
        specMap.put("basePath", this.deriveBasePath(swaggerOption));
        ArrayList tagsList = DfCollectionUtil.newArrayList();
        specMap.put("tags", tagsList);
        swaggerOption.getSecurityDefinitionList().ifPresent(securityDefinitionList -> this.adaptSecurityDefinitions(specMap, (List<Map<String, Object>>)securityDefinitionList));
        LinkedHashMap pathsMap = DfCollectionUtil.newLinkedHashMap();
        specMap.put("paths", pathsMap);
        LinkedHashMap definitionsMap = DfCollectionUtil.newLinkedHashMap();
        specMap.put("definitions", definitionsMap);
        swaggerPathCall.callback(pathsMap, definitionsMap, tagsList);
        swaggerOption.getHeaderParameterList().ifPresent(headerParameterList -> this.adaptHeaderParameters(specMap, (List<Map<String, Object>>)headerParameterList));
        return specMap;
    }

    protected Map<String, String> createSwaggerInfoMap() {
        LinkedHashMap swaggerInfoMap = DfCollectionUtil.newLinkedHashMap();
        String title = this.findSwaggerInfoTitle();
        swaggerInfoMap.put("title", title);
        swaggerInfoMap.put("description", this.deriveSwaggerInfoDescription(title));
        swaggerInfoMap.put("version", this.deriveSwaggerInfoVersion());
        return swaggerInfoMap;
    }

    protected String findSwaggerInfoTitle() {
        String domainTitle = this.accessibleConfig.get("domain.title");
        String domainName = this.accessibleConfig.get("domain.name");
        return Objects.toString(domainTitle, domainName);
    }

    protected String deriveSwaggerInfoDescription(String title) {
        StringBuilder description = new StringBuilder();
        description.append(title);
        description.append(". generated by lasta-meta");
        this.findLastaMetaVersion().ifPresent(version -> {
            description.append("-");
            description.append((String)version);
            description.append(".");
        });
        return description.toString();
    }

    protected String deriveSwaggerInfoVersion() {
        return "1.0.0";
    }

    protected List<String> prepareSwaggerMapSchemes() {
        return Arrays.asList(this.currentRequest.getScheme());
    }

    protected String deriveBasePath(SwaggerOption swaggerOption) {
        StringBuilder basePathSb = new StringBuilder();
        basePathSb.append(this.currentRequest.getContextPath() + "/");
        swaggerOption.getApplicationVersionOnUrl().ifPresent(supplier -> basePathSb.append((String)supplier.get() + "/"));
        String currentPath = basePathSb.toString();
        return (String)swaggerOption.getDerivedBasePath().map(derivedBasePath -> (String)derivedBasePath.apply(currentPath)).orElse((Object)currentPath);
    }

    protected void adaptSecurityDefinitions(Map<String, Object> swaggerMap, List<Map<String, Object>> securityDefinitionList) {
        LinkedHashMap securityDefinitions = DfCollectionUtil.newLinkedHashMap();
        LinkedHashMap security = DfCollectionUtil.newLinkedHashMap();
        swaggerMap.put("securityDefinitions", securityDefinitions);
        swaggerMap.put("security", security);
        securityDefinitionList.forEach(securityDefinition -> {
            securityDefinitions.put(securityDefinition.get("name"), securityDefinition);
            security.put(securityDefinition.get("name"), Arrays.asList(new Object[0]));
        });
    }

    protected void adaptHeaderParameters(Map<String, Object> swaggerMap, List<Map<String, Object>> headerParameterList) {
        if (headerParameterList.isEmpty()) {
            return;
        }
        Object paths = swaggerMap.get("paths");
        if (!(paths instanceof Map)) {
            return;
        }
        Map pathMap = (Map)paths;
        pathMap.forEach((path, pathData) -> {
            if (!(pathData instanceof Map)) {
                return;
            }
            Map pathDataMap = (Map)pathData;
            headerParameterList.forEach(headerParameter -> {
                Object parameters;
                String key = "parameters";
                if (!pathDataMap.containsKey("parameters")) {
                    pathDataMap.put("parameters", DfCollectionUtil.newArrayList());
                }
                if ((parameters = pathDataMap.get("parameters")) instanceof List) {
                    List parameterList = (List)parameters;
                    parameterList.add(headerParameter);
                }
            });
        });
    }

    protected OptionalThing<String> findLastaMetaVersion() {
        return this.createMavenVersionFinder().findVersion("org.lastaflute.meta", "lasta-meta");
    }

    protected MavenVersionFinder createMavenVersionFinder() {
        return new MavenVersionFinder();
    }

    public static interface SwaggerPathCall {
        public void callback(Map<String, Map<String, Object>> var1, Map<String, Map<String, Object>> var2, List<Map<String, Object>> var3);
    }
}

