/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfStringUtil;
import org.lastaflute.core.json.control.JsonControlMeta;
import org.lastaflute.core.json.engine.RealJsonEngine;
import org.lastaflute.di.util.LdiSerializeUtil;
import org.lastaflute.meta.SwaggerOption;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.exception.SwaggerPathSetupFailureException;
import org.lastaflute.meta.swagger.spec.SwaggerSpecPathsMutableOutput;
import org.lastaflute.meta.swagger.spec.parts.annotation.SwaggerSpecAnnotationHandler;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataTypeHandler;
import org.lastaflute.meta.swagger.spec.parts.defaultvalue.SwaggerSpecDefaultValueHandler;
import org.lastaflute.meta.swagger.spec.parts.definition.SwaggerSpecDefinitionHandler;
import org.lastaflute.meta.swagger.spec.parts.encoding.SwaggerSpecEncodingHandler;
import org.lastaflute.meta.swagger.spec.parts.enumtype.SwaggerSpecEnumHandler;
import org.lastaflute.meta.swagger.spec.parts.httpmethod.SwaggerSpecHttpMethodHandler;
import org.lastaflute.meta.swagger.spec.parts.produces.SwaggerSpecProducesHandler;
import org.lastaflute.meta.swagger.spec.parts.property.SwaggerSpecPropertyHandler;
import org.lastaflute.meta.swagger.spec.zone.form.SwaggerSpecFormSetupper;
import org.lastaflute.meta.swagger.spec.zone.jsonbody.SwaggerSpecJsonBodySetupper;
import org.lastaflute.meta.swagger.spec.zone.parameter.SwaggerSpecParameterSetupper;
import org.lastaflute.meta.swagger.spec.zone.responses.SwaggerSpecResponsesSetupper;

public class SwaggerSpecPathsSetupper {
    protected final Map<String, Map<String, Object>> pathsMap;
    protected final Map<String, Map<String, Object>> definitionsMap;
    protected final List<Map<String, Object>> tagsList;
    protected final SwaggerOption swaggerOption;
    protected final RealJsonEngine swaggeruseJsonEngine;
    protected final JsonControlMeta appJsonControlMeta;
    protected final List<Class<?>> nativeDataTypeList;
    protected final SwaggerSpecAnnotationHandler annotationHandler;
    protected final SwaggerSpecEnumHandler enumHandler;
    protected final SwaggerSpecDataTypeHandler dataTypeHandler;
    protected final SwaggerSpecDefaultValueHandler defaultValueHandler;
    protected final SwaggerSpecHttpMethodHandler httpMethodHandler;
    protected final SwaggerSpecPropertyHandler propertyHandler;
    protected final SwaggerSpecDefinitionHandler definitionHandler;
    protected final SwaggerSpecEncodingHandler encodingHandler;
    protected final SwaggerSpecProducesHandler producesHandler;

    public SwaggerSpecPathsSetupper(SwaggerSpecPathsMutableOutput pathMutableOutput, SwaggerOption swaggerOption, RealJsonEngine swaggeruseJsonEngine, JsonControlMeta appJsonControlMeta, List<Class<?>> nativeDataTypeList) {
        this.pathsMap = pathMutableOutput.getPathsMap();
        this.definitionsMap = pathMutableOutput.getDefinitionsMap();
        this.tagsList = pathMutableOutput.getTagsList();
        this.swaggerOption = swaggerOption;
        this.swaggeruseJsonEngine = swaggeruseJsonEngine;
        this.appJsonControlMeta = appJsonControlMeta;
        this.nativeDataTypeList = nativeDataTypeList;
        this.annotationHandler = this.newSwaggerSpecAnnotationHandler();
        this.enumHandler = this.newSwaggerSpecEnumHandler();
        this.dataTypeHandler = this.newSwaggerSpecDataTypeHandler(appJsonControlMeta);
        this.defaultValueHandler = this.newSwaggerSpecDefaultValueHandler(this.dataTypeHandler, this.enumHandler);
        this.httpMethodHandler = this.newSwaggerSpecHttpMethodHandler(swaggerOption);
        this.propertyHandler = this.newSwaggerSpecPropertyHandler(this.annotationHandler);
        this.definitionHandler = this.newSwaggerSpecDefinitionHandler();
        this.encodingHandler = this.newSwaggerSpecEncodingHandler();
        this.producesHandler = this.newSwaggerSpecProducesHandler(this.dataTypeHandler);
    }

    protected SwaggerSpecAnnotationHandler newSwaggerSpecAnnotationHandler() {
        return new SwaggerSpecAnnotationHandler();
    }

    protected SwaggerSpecEnumHandler newSwaggerSpecEnumHandler() {
        return new SwaggerSpecEnumHandler();
    }

    protected SwaggerSpecDataTypeHandler newSwaggerSpecDataTypeHandler(JsonControlMeta appJsonControlMeta) {
        return new SwaggerSpecDataTypeHandler(appJsonControlMeta);
    }

    protected SwaggerSpecDefaultValueHandler newSwaggerSpecDefaultValueHandler(SwaggerSpecDataTypeHandler dataTypeHandler, SwaggerSpecEnumHandler enumHandler) {
        return new SwaggerSpecDefaultValueHandler(dataTypeHandler, enumHandler);
    }

    protected SwaggerSpecHttpMethodHandler newSwaggerSpecHttpMethodHandler(SwaggerOption swaggerOption) {
        return new SwaggerSpecHttpMethodHandler(swaggerOption);
    }

    protected SwaggerSpecPropertyHandler newSwaggerSpecPropertyHandler(SwaggerSpecAnnotationHandler annotationHandler) {
        return new SwaggerSpecPropertyHandler(annotationHandler);
    }

    protected SwaggerSpecDefinitionHandler newSwaggerSpecDefinitionHandler() {
        return new SwaggerSpecDefinitionHandler();
    }

    protected SwaggerSpecEncodingHandler newSwaggerSpecEncodingHandler() {
        return new SwaggerSpecEncodingHandler();
    }

    protected SwaggerSpecProducesHandler newSwaggerSpecProducesHandler(SwaggerSpecDataTypeHandler dataTypeHandler) {
        return new SwaggerSpecProducesHandler(dataTypeHandler);
    }

    public void setupSwaggerPathsMap(List<ActionDocMeta> actionDocMetaList) {
        actionDocMetaList.stream().forEach(actionDocMeta -> {
            try {
                this.doSetupSwaggerPathsMap((ActionDocMeta)actionDocMeta);
            }
            catch (RuntimeException e) {
                String msg = this.buildParseFailureMessage((ActionDocMeta)actionDocMeta);
                throw new SwaggerPathSetupFailureException(msg, e);
            }
        });
    }

    protected String buildParseFailureMessage(ActionDocMeta actionDocMeta) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to set up swagger path for the action.");
        br.addItem("Advice");
        br.addElement((Object)"Make sure your Action definition.");
        br.addElement((Object)"And look at the next exception messages.");
        br.addItem("actionDocMeta");
        br.addElement((Object)actionDocMeta);
        br.addItem("Action Class");
        br.addElement((Object)actionDocMeta.getActionExecute().getActionType());
        br.addItem("Execute Method");
        br.addElement((Object)actionDocMeta.getActionExecute().toSimpleMethodExp());
        return br.buildExceptionMessage();
    }

    protected void doSetupSwaggerPathsMap(ActionDocMeta actionDocMeta) {
        String actionUrl = actionDocMeta.getUrl();
        if (!this.pathsMap.containsKey(actionUrl)) {
            LinkedHashMap swaggerUrlMap = DfCollectionUtil.newLinkedHashMap();
            this.pathsMap.put(actionUrl, swaggerUrlMap);
        }
        String httpMethod = this.httpMethodHandler.extractHttpMethod(actionDocMeta);
        LinkedHashMap httpMethodContentMap = DfCollectionUtil.newLinkedHashMap();
        this.pathsMap.get(actionUrl).put(httpMethod, httpMethodContentMap);
        httpMethodContentMap.put("summary", actionDocMeta.getDescription());
        httpMethodContentMap.put("description", actionDocMeta.getDescription());
        ArrayList parameterMapList = DfCollectionUtil.newArrayList();
        ArrayList optionalPathNameList = DfCollectionUtil.newArrayList();
        parameterMapList.addAll(actionDocMeta.getParameterTypeDocMetaList().stream().map(typeDocMeta -> {
            Map<String, Object> parameterMap = this.toParameterMap((TypeDocMeta)typeDocMeta);
            parameterMap.put("in", "path");
            if (parameterMap.containsKey("example")) {
                parameterMap.put("default", parameterMap.get("example"));
                parameterMap.remove("example");
            }
            parameterMap.put("required", true);
            if (OptionalThing.class.isAssignableFrom(typeDocMeta.getType())) {
                optionalPathNameList.add(typeDocMeta.getPublicName());
            }
            return parameterMap;
        }).collect(Collectors.toList()));
        if (actionDocMeta.getFormTypeDocMeta() != null) {
            if (actionDocMeta.getFormTypeDocMeta().getTypeName().endsWith("Form")) {
                this.prepareForm(actionDocMeta, httpMethod, httpMethodContentMap, parameterMapList);
            } else {
                this.prepareJsonBody(actionDocMeta, httpMethodContentMap, parameterMapList);
            }
        }
        httpMethodContentMap.put("parameters", parameterMapList);
        String tag = this.deriveActionTag(actionDocMeta);
        httpMethodContentMap.put("tags", Arrays.asList(tag));
        if (this.isNewTag(tag)) {
            this.registerNewTagToTopLevel(tag);
        }
        this.prepareResponses(httpMethodContentMap, actionDocMeta);
        if (!optionalPathNameList.isEmpty()) {
            this.prepareOptionalParameterPath(actionDocMeta, optionalPathNameList);
        }
    }

    protected void prepareForm(ActionDocMeta actionDocMeta, String httpMethod, Map<String, Object> httpMethodContentMap, List<Map<String, Object>> parameterMapList) {
        SwaggerSpecFormSetupper formSetupper = new SwaggerSpecFormSetupper(this.annotationHandler, meta -> this.toParameterMap((TypeDocMeta)meta));
        formSetupper.prepareForm(actionDocMeta, httpMethod, httpMethodContentMap, parameterMapList);
    }

    protected void prepareJsonBody(ActionDocMeta actionDocMeta, Map<String, Object> httpMethodContentMap, List<Map<String, Object>> parameterMapList) {
        SwaggerSpecJsonBodySetupper jsonBodySetupper = new SwaggerSpecJsonBodySetupper(this.annotationHandler, this.propertyHandler, this.definitionHandler, this.encodingHandler, meta -> this.toParameterMap((TypeDocMeta)meta));
        jsonBodySetupper.prepareJsonBody(actionDocMeta, this.definitionsMap, httpMethodContentMap, parameterMapList);
    }

    protected String deriveActionTag(ActionDocMeta actionDocMeta) {
        if ("RootAction".equals(actionDocMeta.getType().getSimpleName())) {
            return "root";
        }
        String actionUrl = actionDocMeta.getUrl();
        return DfStringUtil.substringFirstFront((String)actionUrl.replaceAll("^/", ""), (String[])new String[]{"/"});
    }

    protected boolean isNewTag(String tag) {
        return this.tagsList.stream().noneMatch(swaggerTag -> swaggerTag.containsValue(tag));
    }

    protected boolean registerNewTagToTopLevel(String tag) {
        return this.tagsList.add(DfCollectionUtil.newLinkedHashMap((Object)"name", (Object)tag));
    }

    protected void prepareOptionalParameterPath(ActionDocMeta actionDocMeta, List<String> optionalPathNameList) {
        String actionUrl = actionDocMeta.getUrl();
        String httpMethod = this.httpMethodHandler.extractHttpMethod(actionDocMeta);
        IntStream.range(0, optionalPathNameList.size()).forEach(index -> {
            List<String> currentOptionalPathNameList = optionalPathNameList.subList(index, optionalPathNameList.size());
            String currentUrl = currentOptionalPathNameList.stream().reduce(actionUrl, (workingActionUrl, optionalPathName) -> workingActionUrl.replaceAll("/\\{" + optionalPathName + "\\}", ""));
            if (!this.pathsMap.containsKey(currentUrl)) {
                this.pathsMap.put(currentUrl, DfCollectionUtil.newLinkedHashMap());
            }
            Map swaggerHttpMethodMap = (Map)LdiSerializeUtil.serialize((Object)this.pathsMap.get(actionUrl).get(httpMethod));
            this.prepareOptionalSwaggerHttpMethodMap(swaggerHttpMethodMap, currentOptionalPathNameList);
            this.pathsMap.get(currentUrl).put(httpMethod, swaggerHttpMethodMap);
        });
        Map<String, Object> swaggerUrlMap = this.pathsMap.remove(actionUrl);
        this.pathsMap.put(actionUrl, swaggerUrlMap);
    }

    protected void prepareOptionalSwaggerHttpMethodMap(Map<String, Object> swaggerHttpMethodMap, List<String> currentOptionalPathNameList) {
        String parametersKey = "parameters";
        List parametersSnapshotList = (List)swaggerHttpMethodMap.get("parameters");
        List filteredParameterMapList = parametersSnapshotList.stream().filter(parameterMap -> !currentOptionalPathNameList.contains(parameterMap.get("name"))).collect(Collectors.toList());
        swaggerHttpMethodMap.put("parameters", filteredParameterMapList);
    }

    protected void prepareResponses(Map<String, Object> swaggerHttpMethodMap, ActionDocMeta actionDocMeta) {
        SwaggerSpecResponsesSetupper responsesSetupper = new SwaggerSpecResponsesSetupper(this.swaggerOption, this.producesHandler, meta -> this.toParameterMap((TypeDocMeta)meta));
        responsesSetupper.prepareResponses(swaggerHttpMethodMap, actionDocMeta);
    }

    protected Map<String, Object> toParameterMap(TypeDocMeta typeDocMeta) {
        SwaggerSpecParameterSetupper parameterSetupper = new SwaggerSpecParameterSetupper(this.nativeDataTypeList, this.enumHandler, this.dataTypeHandler, this.defaultValueHandler, this.propertyHandler, this.definitionHandler, this.encodingHandler);
        return parameterSetupper.toParameterMap(typeDocMeta, this.definitionsMap);
    }
}

