/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.parts.datatype;

import java.util.function.BiFunction;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.exception.SwaggerDefaultValueTypeConversionFailureException;

public class SwaggerSpecDataType {
    public final String type;
    public final String format;
    public final BiFunction<TypeDocMeta, Object, Object> defaultValueFunction;

    public SwaggerSpecDataType(String type, String format, BiFunction<TypeDocMeta, Object, Object> defaultValueFunction) {
        this.type = type;
        this.format = format;
        this.defaultValueFunction = (typeDocMeta, value) -> {
            try {
                return defaultValueFunction.apply((TypeDocMeta)typeDocMeta, value);
            }
            catch (RuntimeException e) {
                String msg = this.buildDefaultValueTypeConversionFailureMessage((TypeDocMeta)typeDocMeta, value);
                throw new SwaggerDefaultValueTypeConversionFailureException(msg, e);
            }
        };
    }

    protected String buildDefaultValueTypeConversionFailureMessage(TypeDocMeta typeDocMeta, Object value) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Cannot convert the \"e.g. default value\" to property type");
        br.addItem("Advice");
        br.addElement((Object)"Make sure your \"e.g. default value\" in javadoc's comment.");
        br.addElement((Object)"Mismatched type? or Broken expression?");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x): (mismatched type)");
        br.addElement((Object)"    /** Sea Count e.g. over */ *Bad");
        br.addElement((Object)"    public Integer seaCount;");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /** Sea Count e.g. 1 */ OK");
        br.addElement((Object)"    public Integer seaCount;");
        br.addElement((Object)"");
        br.addElement((Object)"  (x): (broken expression)");
        br.addElement((Object)"    /** Sea Date e.g. 2022@04-18 */ *Bad");
        br.addElement((Object)"    public LocalDate seaDate;");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /** Sea Date e.g. 2022-04-18 */ OK");
        br.addElement((Object)"    public LocalDate seaDate;");
        br.addItem("typeDocMeta");
        br.addElement((Object)typeDocMeta);
        br.addItem("Property Name");
        br.addElement((Object)typeDocMeta.getName());
        br.addItem("Property Type");
        br.addElement(typeDocMeta.getType());
        String simpleTypeName = typeDocMeta.getSimpleTypeName();
        if (simpleTypeName != null) {
            br.addElement((Object)("(type name: " + simpleTypeName + ")"));
        }
        br.addItem("Javadoc");
        br.addElement((Object)typeDocMeta.getComment());
        br.addItem("Default Value");
        br.addElement(value);
        return br.buildExceptionMessage();
    }
}

