/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.parts.datatype;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.lastaflute.core.json.annotation.JsonDatePattern;
import org.lastaflute.core.json.control.JsonControlMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataType;
import org.lastaflute.web.ruts.multipart.MultipartFormFile;

public class SwaggerSpecDataTypeHandler {
    protected final JsonControlMeta appJsonControlMeta;

    public SwaggerSpecDataTypeHandler(JsonControlMeta appJsonControlMeta) {
        this.appJsonControlMeta = appJsonControlMeta;
    }

    public Map<Class<?>, SwaggerSpecDataType> createSwaggerDataTypeMap() {
        LinkedHashMap typeMap = DfCollectionUtil.newLinkedHashMap();
        typeMap.put(Boolean.TYPE, new SwaggerSpecDataType("boolean", null, (typeDocMeta, value) -> DfTypeUtil.toBoolean((Object)value)));
        typeMap.put(Byte.TYPE, new SwaggerSpecDataType("byte", null, (typeDocMeta, value) -> DfTypeUtil.toByte((Object)value)));
        typeMap.put(Integer.TYPE, new SwaggerSpecDataType("integer", "int32", (typeDocMeta, value) -> DfTypeUtil.toInteger((Object)value)));
        typeMap.put(Long.TYPE, new SwaggerSpecDataType("integer", "int64", (typeDocMeta, value) -> DfTypeUtil.toLong((Object)value)));
        typeMap.put(Float.TYPE, new SwaggerSpecDataType("integer", "float", (typeDocMeta, value) -> DfTypeUtil.toFloat((Object)value)));
        typeMap.put(Double.TYPE, new SwaggerSpecDataType("integer", "double", (typeDocMeta, value) -> DfTypeUtil.toDouble((Object)value)));
        typeMap.put(Boolean.class, new SwaggerSpecDataType("boolean", null, (typeDocMeta, value) -> DfTypeUtil.toBoolean((Object)value)));
        typeMap.put(Byte.class, new SwaggerSpecDataType("boolean", null, (typeDocMeta, value) -> DfTypeUtil.toByte((Object)value)));
        typeMap.put(Integer.class, new SwaggerSpecDataType("integer", "int32", (typeDocMeta, value) -> DfTypeUtil.toInteger((Object)value)));
        typeMap.put(Long.class, new SwaggerSpecDataType("integer", "int64", (typeDocMeta, value) -> DfTypeUtil.toLong((Object)value)));
        typeMap.put(Float.class, new SwaggerSpecDataType("number", "float", (typeDocMeta, value) -> DfTypeUtil.toFloat((Object)value)));
        typeMap.put(Double.class, new SwaggerSpecDataType("number", "double", (typeDocMeta, value) -> DfTypeUtil.toDouble((Object)value)));
        typeMap.put(BigDecimal.class, new SwaggerSpecDataType("integer", "double", (typeDocMeta, value) -> DfTypeUtil.toBigDecimal((Object)value)));
        typeMap.put(String.class, new SwaggerSpecDataType("string", null, (typeDocMeta, value) -> value));
        typeMap.put(byte[].class, new SwaggerSpecDataType("string", "byte", (typeDocMeta, value) -> value));
        typeMap.put(Byte[].class, new SwaggerSpecDataType("string", "byte", (typeDocMeta, value) -> value));
        typeMap.put(Date.class, new SwaggerSpecDataType("string", "date", (typeDocMeta, value) -> value == null ? this.getLocalDateFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalDate()) : value));
        typeMap.put(LocalDate.class, new SwaggerSpecDataType("string", "date", (typeDocMeta, value) -> value == null ? this.getLocalDateFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalDate()) : value));
        typeMap.put(LocalDateTime.class, new SwaggerSpecDataType("string", "date-time", (typeDocMeta, value) -> value == null ? this.getLocalDateTimeFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalDateTime()) : value));
        String localTimeFormat = null;
        typeMap.put(LocalTime.class, new SwaggerSpecDataType("string", localTimeFormat, (typeDocMeta, value) -> value == null ? this.getLocalTimeFormatter((TypeDocMeta)typeDocMeta).format(this.getDefaultLocalTime()) : value));
        typeMap.put(MultipartFormFile.class, new SwaggerSpecDataType("file", null, (typeDocMeta, value) -> value));
        return typeMap;
    }

    protected LocalDate getDefaultLocalDate() {
        return LocalDate.ofYearDay(2000, 1);
    }

    protected LocalDateTime getDefaultLocalDateTime() {
        return this.getDefaultLocalDate().atStartOfDay();
    }

    protected LocalTime getDefaultLocalTime() {
        return LocalTime.from(this.getDefaultLocalDateTime());
    }

    protected DateTimeFormatter getLocalDateFormatter(TypeDocMeta typeDocMeta) {
        Optional<DateTimeFormatter> jsonDatePatternDateTimeFormatter = this.getJsonDatePatternDateTimeFormatter(typeDocMeta);
        if (jsonDatePatternDateTimeFormatter.isPresent()) {
            return jsonDatePatternDateTimeFormatter.get();
        }
        return (DateTimeFormatter)this.appJsonControlMeta.getMappingControlMeta().flatMap(meta -> meta.getLocalDateFormatter()).orElseGet(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    protected DateTimeFormatter getLocalDateTimeFormatter(TypeDocMeta typeDocMeta) {
        Optional<DateTimeFormatter> jsonDatePatternDateTimeFormatter = this.getJsonDatePatternDateTimeFormatter(typeDocMeta);
        if (jsonDatePatternDateTimeFormatter.isPresent()) {
            return jsonDatePatternDateTimeFormatter.get();
        }
        return (DateTimeFormatter)this.appJsonControlMeta.getMappingControlMeta().flatMap(meta -> meta.getLocalDateTimeFormatter()).orElseGet(() -> DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS"));
    }

    protected DateTimeFormatter getLocalTimeFormatter(TypeDocMeta typeDocMeta) {
        Optional<DateTimeFormatter> jsonDatePatternDateTimeFormatter = this.getJsonDatePatternDateTimeFormatter(typeDocMeta);
        if (jsonDatePatternDateTimeFormatter.isPresent()) {
            return jsonDatePatternDateTimeFormatter.get();
        }
        return (DateTimeFormatter)this.appJsonControlMeta.getMappingControlMeta().flatMap(meta -> meta.getLocalTimeFormatter()).orElseGet(() -> DateTimeFormatter.ofPattern("HH:mm:ss.SSS"));
    }

    protected Optional<DateTimeFormatter> getJsonDatePatternDateTimeFormatter(TypeDocMeta typeDocMeta) {
        return typeDocMeta.getAnnotationTypeList().stream().filter(annotationType -> annotationType instanceof JsonDatePattern).findFirst().map(jsonDatePattern -> DateTimeFormatter.ofPattern(((JsonDatePattern)jsonDatePattern).value()));
    }
}

