/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.parts.defaultvalue;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dbflute.helper.dfmap.DfMapStyle;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfStringUtil;
import org.dbflute.util.Srl;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.exception.SwaggerDefaultValueParseFailureException;
import org.lastaflute.meta.exception.SwaggerDefaultValueTypeConversionFailureException;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataType;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataTypeHandler;
import org.lastaflute.meta.swagger.spec.parts.enumtype.SwaggerSpecEnumHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerSpecDefaultValueHandler {
    private static final Logger logger = LoggerFactory.getLogger(SwaggerSpecDefaultValueHandler.class);
    protected final SwaggerSpecDataTypeHandler dataTypeHandler;
    protected final SwaggerSpecEnumHandler enumHandler;

    public SwaggerSpecDefaultValueHandler(SwaggerSpecDataTypeHandler dataTypeHandler, SwaggerSpecEnumHandler enumHandler) {
        this.dataTypeHandler = dataTypeHandler;
        this.enumHandler = enumHandler;
    }

    public OptionalThing<Object> deriveDefaultValue(TypeDocMeta typeDocMeta) {
        try {
            Map<Class<?>, SwaggerSpecDataType> swaggerDataTypeMap = this.dataTypeHandler.createSwaggerDataTypeMap();
            if (swaggerDataTypeMap.containsKey(typeDocMeta.getType())) {
                return this.doDeriveScalarDefalutValue(typeDocMeta, swaggerDataTypeMap);
            }
            if (this.isNonNestIterable(typeDocMeta)) {
                return this.doDeriveListDefalutValue(typeDocMeta, swaggerDataTypeMap);
            }
            if (this.isNonNestMap(typeDocMeta)) {
                return this.doDeriveMapDefalutValue(typeDocMeta, swaggerDataTypeMap);
            }
            if (Enum.class.isAssignableFrom(typeDocMeta.getType())) {
                return this.doDeriveEnumDefaultValue(typeDocMeta, swaggerDataTypeMap);
            }
            return OptionalThing.empty();
        }
        catch (RuntimeException e) {
            if (e instanceof SwaggerDefaultValueTypeConversionFailureException) {
                throw e;
            }
            String msg = this.buildParseFailureMessage(typeDocMeta);
            throw new SwaggerDefaultValueParseFailureException(msg, e);
        }
    }

    protected String buildParseFailureMessage(TypeDocMeta typeDocMeta) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to parse the \"e.g. default value\" in javadoc's comment.");
        br.addItem("Advice");
        br.addElement((Object)"Make sure your \"e.g. default value\" in javadoc's comment.");
        br.addElement((Object)"Mismatched type? or Broken expression?");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x): (mismatched type)");
        br.addElement((Object)"    /** Sea Count e.g. over */ *Bad");
        br.addElement((Object)"    public Integer seaCount;");
        br.addElement((Object)"  (o): (correct type)");
        br.addElement((Object)"    /** Sea Count e.g. 1 */ OK");
        br.addElement((Object)"    public Integer seaCount;");
        br.addElement((Object)"");
        br.addElement((Object)"  (x): (broken expression)");
        br.addElement((Object)"    /** Sea Date e.g. 2022@04-18 */ *Bad");
        br.addElement((Object)"    public LocalDate seaDate;");
        br.addElement((Object)"  (o): (correct expression)");
        br.addElement((Object)"    /** Sea Date e.g. 2022-04-18 */ OK");
        br.addElement((Object)"    public LocalDate seaDate;");
        br.addElement((Object)"");
        br.addElement((Object)"  (x): (broken expression)");
        br.addElement((Object)"    /** Sea Map e.g. {dockside=over,hangar=mystic} */ *Bad");
        br.addElement((Object)"    public Map<String, String> seaMap;");
        br.addElement((Object)"  (o): (correct map)");
        br.addElement((Object)"    /** Sea Map e.g. {dockside:over,hangar:mystic} */ OK: JSON style");
        br.addElement((Object)"    public Map<String, String> seaMap;");
        br.addItem("typeDocMeta");
        br.addElement((Object)typeDocMeta);
        br.addItem("Property Name");
        br.addElement((Object)typeDocMeta.getName());
        br.addItem("Property Type");
        br.addElement(typeDocMeta.getType());
        String simpleTypeName = typeDocMeta.getSimpleTypeName();
        if (simpleTypeName != null) {
            br.addElement((Object)("(type name: " + simpleTypeName + ")"));
        }
        br.addItem("Javadoc");
        br.addElement((Object)typeDocMeta.getComment());
        return br.buildExceptionMessage();
    }

    protected OptionalThing<Object> doDeriveScalarDefalutValue(TypeDocMeta typeDocMeta, Map<Class<?>, SwaggerSpecDataType> swaggerDataTypeMap) {
        SwaggerSpecDataType swaggerType = swaggerDataTypeMap.get(typeDocMeta.getType());
        Object extracted = this.extractDefaultValueFromComment(typeDocMeta.getComment());
        Object defaultValue = swaggerType.defaultValueFunction.apply(typeDocMeta, extracted);
        return OptionalThing.ofNullable((Object)defaultValue, () -> {
            throw new IllegalStateException("Not found the default value: " + typeDocMeta);
        });
    }

    protected boolean isNonNestIterable(TypeDocMeta typeDocMeta) {
        return Iterable.class.isAssignableFrom(typeDocMeta.getType()) && typeDocMeta.getNestTypeDocMetaList().isEmpty();
    }

    protected OptionalThing<Object> doDeriveListDefalutValue(TypeDocMeta typeDocMeta, Map<Class<?>, SwaggerSpecDataType> swaggerDataTypeMap) {
        SwaggerSpecDataType swaggerType;
        Object defaultValue = this.extractDefaultValueFromComment(typeDocMeta.getComment());
        if (!(defaultValue instanceof List)) {
            return OptionalThing.empty();
        }
        List defaultValueList = (List)defaultValue;
        Class<Object> genericType = typeDocMeta.getGenericType();
        if (genericType == null) {
            genericType = String.class;
        }
        if ((swaggerType = swaggerDataTypeMap.get(genericType)) != null) {
            return OptionalThing.of(defaultValueList.stream().map(value -> swaggerType.defaultValueFunction.apply(typeDocMeta, value)).collect(Collectors.toList()));
        }
        return OptionalThing.empty();
    }

    protected boolean isNonNestMap(TypeDocMeta typeDocMeta) {
        return Map.class.isAssignableFrom(typeDocMeta.getType()) && typeDocMeta.getNestTypeDocMetaList().isEmpty();
    }

    protected OptionalThing<Object> doDeriveMapDefalutValue(TypeDocMeta typeDocMeta, Map<Class<?>, SwaggerSpecDataType> swaggerDataTypeMap) {
        String[] keyValueArray = this.extractMapGenericTypeAsArray(typeDocMeta);
        if (keyValueArray == null || keyValueArray.length <= 1) {
            return OptionalThing.empty();
        }
        String keyTypeName = keyValueArray[0].trim();
        String valueTypeName = keyValueArray[1].trim();
        String comment = typeDocMeta.getComment();
        return OptionalThing.ofNullable((Object)this.deriveMapDefaultValueByComment(comment, keyTypeName, valueTypeName), () -> {
            throw new IllegalStateException("not found default value: " + typeDocMeta.getName() + ", " + comment);
        });
    }

    protected String[] extractMapGenericTypeAsArray(TypeDocMeta typeDocMeta) {
        String typeName = typeDocMeta.getTypeName();
        if (typeName == null || !typeName.contains("<")) {
            return null;
        }
        String genericPart = Srl.substringFirstFront((String)Srl.substringFirstRear((String)typeName, (String[])new String[]{"<"}), (String[])new String[]{">"});
        return genericPart.split(",");
    }

    protected Object deriveMapDefaultValueByComment(String comment, String keyTypeName, String valueTypeName) {
        if (DfStringUtil.is_Null_or_Empty((String)comment)) {
            return null;
        }
        String egMark = "e.g.";
        if (!comment.contains("e.g.")) {
            return null;
        }
        String egRearPart = Srl.substringFirstRear((String)comment, (String[])new String[]{"e.g."}).trim();
        if (egRearPart.startsWith("\"") && Srl.count((String)egRearPart, (String)"\"") >= 2) {
            egRearPart = Srl.substringLastFront((String)Srl.substringFirstRear((String)egRearPart, (String[])new String[]{"\""}), (String[])new String[]{"\""}).trim();
        }
        if (egRearPart.startsWith("{")) {
            String defaultValue = Srl.substringLastFront((String)Srl.substringFirstRear((String)egRearPart, (String[])new String[]{"{"}), (String[])new String[]{"}"});
            LinkedHashMap map = DfCollectionUtil.newLinkedHashMap();
            if (defaultValue.isEmpty()) {
                return map;
            }
            for (String keyValueEntry : defaultValue.split(",")) {
                String[] entry = keyValueEntry.split(":");
                String key = this.adjustMapKeyValueFormat(entry[0]);
                String value = this.adjustMapKeyValueFormat(entry[1]);
                map.put(key, value);
            }
            return map;
        }
        if (egRearPart.startsWith("map:{")) {
            String mapStyle = Srl.substringLastFront((String)egRearPart, (String[])new String[]{"}"}) + "}";
            try {
                return new DfMapStyle().fromMapString(mapStyle);
            }
            catch (RuntimeException continued) {
                logger.debug("Failed to challenge it as map style: mapStyle=" + mapStyle, (Throwable)continued);
                return null;
            }
        }
        return null;
    }

    private String adjustMapKeyValueFormat(String exp) {
        String trimmed = exp.trim();
        String filtered = Srl.isQuotedDouble((String)trimmed) ? Srl.unquoteDouble((String)trimmed) : (Srl.isQuotedSingle((String)trimmed) ? Srl.unquoteSingle((String)trimmed) : trimmed);
        return filtered;
    }

    protected OptionalThing<Object> doDeriveEnumDefaultValue(TypeDocMeta typeDocMeta, Map<Class<?>, SwaggerSpecDataType> swaggerDataTypeMap) {
        Object defaultValue = this.extractDefaultValueFromComment(typeDocMeta.getComment());
        if (defaultValue != null) {
            return OptionalThing.of((Object)defaultValue);
        }
        Class<?> enumClass = typeDocMeta.getType();
        List<Map<String, String>> enumMapList = this.enumHandler.buildEnumMapList(enumClass);
        Optional<Object> firstEnumElement = enumMapList.stream().map(e -> e.get("code")).findFirst();
        return OptionalThing.migratedFrom(firstEnumElement, () -> {
            throw new IllegalStateException("not found enum value.");
        });
    }

    protected Object extractDefaultValueFromComment(String comment) {
        if (DfStringUtil.is_Null_or_Empty((String)comment)) {
            return null;
        }
        String parsedComment = comment.replaceAll("\r?\n", " ").trim();
        parsedComment = Srl.replace((String)parsedComment, (String)"e.g.  ", (String)"e.g.").trim();
        if ((parsedComment = Srl.replace((String)parsedComment, (String)"e.g. ", (String)"e.g.").trim()).contains("e.g.\"")) {
            return Srl.substringFirstFront((String)Srl.substringFirstRear((String)parsedComment, (String[])new String[]{"e.g.\""}), (String[])new String[]{"\""}).trim();
        }
        if (parsedComment.contains("e.g.[")) {
            String defaultValue = Srl.substringFirstFront((String)Srl.substringFirstRear((String)parsedComment, (String[])new String[]{"e.g.["}), (String[])new String[]{"]"}).trim();
            return Arrays.stream(defaultValue.split(", *")).map(value -> value.trim()).map(value -> {
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    return value.substring(1, value.length() - 1);
                }
                return "null".equals(value) ? null : value;
            }).collect(Collectors.toList());
        }
        Pattern pattern = Pattern.compile("e\\.g\\.([^ ]+)");
        Matcher matcher = pattern.matcher(parsedComment);
        if (matcher.find()) {
            String value2 = matcher.group(1);
            return "null".equals(value2) ? null : value2;
        }
        return null;
    }
}

