/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.parts.httpmethod;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lastaflute.meta.SwaggerOption;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;

public class SwaggerSpecHttpMethodHandler {
    protected static final Pattern HTTP_METHOD_PATTERN = Pattern.compile("(.+)\\$.+");
    protected final SwaggerOption swaggerOption;

    public SwaggerSpecHttpMethodHandler(SwaggerOption swaggerOption) {
        this.swaggerOption = swaggerOption;
    }

    public String extractHttpMethod(ActionDocMeta actionDocMeta) {
        Matcher matcher = HTTP_METHOD_PATTERN.matcher(actionDocMeta.getMethodName());
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (actionDocMeta.getFormTypeDocMeta() != null && !actionDocMeta.getFormTypeDocMeta().getTypeName().endsWith("Form")) {
            return "post";
        }
        return this.swaggerOption.getDefaultFormHttpMethod().apply(actionDocMeta);
    }
}

