/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.parts.produces;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataType;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataTypeHandler;
import org.lastaflute.web.response.HtmlResponse;
import org.lastaflute.web.response.JsonResponse;
import org.lastaflute.web.response.StreamResponse;
import org.lastaflute.web.response.XmlResponse;

public class SwaggerSpecProducesHandler {
    protected static final Map<Class<?>, List<String>> produceMap;
    protected final SwaggerSpecDataTypeHandler dataTypeHandler;

    public SwaggerSpecProducesHandler(SwaggerSpecDataTypeHandler dataTypeHandler) {
        this.dataTypeHandler = dataTypeHandler;
    }

    public OptionalThing<List<String>> deriveProduces(ActionDocMeta actionDocMeta) {
        TypeDocMeta returnTypeDocMeta = actionDocMeta.getReturnTypeDocMeta();
        if (Arrays.asList(Void.TYPE, Void.class).contains(returnTypeDocMeta.getGenericType())) {
            return OptionalThing.empty();
        }
        Map<Class<?>, SwaggerSpecDataType> dataTypeMap = this.dataTypeHandler.createSwaggerDataTypeMap();
        if (dataTypeMap.containsKey(returnTypeDocMeta.getGenericType())) {
            return OptionalThing.of(Arrays.asList("text/plain;charset=UTF-8"));
        }
        Class<?> produceType = returnTypeDocMeta.getType();
        List<String> produceList = produceMap.get(produceType);
        return OptionalThing.ofNullable(produceList, () -> {
            String msg = "Not found the produce: type=" + produceType + ", keys=" + produceMap.keySet();
            throw new IllegalStateException(msg);
        });
    }

    static {
        HashMap workingMap = DfCollectionUtil.newHashMap();
        workingMap.put(JsonResponse.class, Arrays.asList("application/json"));
        workingMap.put(XmlResponse.class, Arrays.asList("application/xml"));
        workingMap.put(HtmlResponse.class, Arrays.asList("text/html"));
        workingMap.put(StreamResponse.class, Arrays.asList("application/octet-stream"));
        produceMap = Collections.unmodifiableMap(workingMap);
    }
}

