/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.zone.form;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.lastaflute.meta.document.docmeta.ActionDocMeta;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.swagger.spec.parts.annotation.SwaggerSpecAnnotationHandler;

public class SwaggerSpecFormSetupper {
    protected final SwaggerSpecAnnotationHandler annotationHandler;
    protected final Function<TypeDocMeta, Map<String, Object>> parameterMapProvider;

    public SwaggerSpecFormSetupper(SwaggerSpecAnnotationHandler annotationHandler, Function<TypeDocMeta, Map<String, Object>> parameterMapProvider) {
        this.annotationHandler = annotationHandler;
        this.parameterMapProvider = parameterMapProvider;
    }

    public void prepareForm(ActionDocMeta actionDocMeta, String httpMethod, Map<String, Object> httpMethodContentMap, List<Map<String, Object>> parameterMapList) {
        List<TypeDocMeta> nestTypeDocMetaList = actionDocMeta.getFormTypeDocMeta().getNestTypeDocMetaList();
        nestTypeDocMetaList.stream().map(typeDocMeta -> this.setupFormParameter(httpMethod, (TypeDocMeta)typeDocMeta)).forEach(parameterMap -> parameterMapList.add((Map<String, Object>)parameterMap));
        this.setupConsumesIfFormData(httpMethodContentMap, parameterMapList);
    }

    protected Map<String, Object> setupFormParameter(String httpMethod, TypeDocMeta typeDocMeta) {
        Map<String, Object> parameterMap = this.parameterMapProvider.apply(typeDocMeta);
        this.adjustDollarRef(httpMethod, parameterMap);
        this.adjustItems(httpMethod, parameterMap);
        this.adjustObjectType(httpMethod, parameterMap);
        this.adjustParameterName(httpMethod, parameterMap, typeDocMeta);
        this.adjustIn(httpMethod, parameterMap);
        this.adjustExample(httpMethod, parameterMap);
        this.adjustRequired(httpMethod, parameterMap, typeDocMeta);
        this.adjustCollectionFormat(httpMethod, parameterMap);
        return parameterMap;
    }

    protected void adjustDollarRef(String httpMethod, Map<String, Object> parameterMap) {
        if (parameterMap.containsKey("$ref")) {
            parameterMap.remove("$ref");
            parameterMap.put("type", "string");
        }
    }

    protected void adjustItems(String httpMethod, Map<String, Object> parameterMap) {
        if (parameterMap.containsKey("items")) {
            Map items = (Map)parameterMap.get("items");
            this.adjustDollarRef(httpMethod, items);
            this.adjustObjectType(httpMethod, items);
        }
    }

    protected void adjustObjectType(String httpMethod, Map<String, Object> parameterMap) {
        if ("object".equals(parameterMap.get("type"))) {
            parameterMap.put("type", "string");
        }
    }

    protected void adjustParameterName(String httpMethod, Map<String, Object> parameterMap, TypeDocMeta typeDocMeta) {
        parameterMap.put("name", typeDocMeta.getPublicName());
    }

    protected void adjustIn(String httpMethod, Map<String, Object> parameterMap) {
        parameterMap.put("in", this.isQueryParameter(httpMethod) ? "query" : "formData");
    }

    protected boolean isQueryParameter(String httpMethod) {
        return Arrays.asList("get", "delete").contains(httpMethod);
    }

    protected void adjustExample(String httpMethod, Map<String, Object> parameterMap) {
        if (parameterMap.containsKey("example")) {
            parameterMap.put("default", parameterMap.get("example"));
            parameterMap.remove("example");
        }
    }

    protected void adjustRequired(String httpMethod, Map<String, Object> parameterMap, TypeDocMeta typeDocMeta) {
        parameterMap.put("required", typeDocMeta.getAnnotationTypeList().stream().anyMatch(annoType -> this.annotationHandler.getRequiredAnnotationList().stream().anyMatch(requiredAnno -> requiredAnno.isAssignableFrom(annoType.getClass()))));
    }

    protected void adjustCollectionFormat(String httpMethod, Map<String, Object> parameterMap) {
        if (this.needsCollectionFormatMulti(parameterMap)) {
            parameterMap.put("collectionFormat", "multi");
        }
    }

    protected boolean needsCollectionFormatMulti(Map<String, Object> parameterMap) {
        return this.isParameterInputQuery(parameterMap) || this.isParameterInputFormData(parameterMap);
    }

    protected void setupConsumesIfFormData(Map<String, Object> httpMethodContentMap, List<Map<String, Object>> parameterMapList) {
        if (this.hasFormDataInput(parameterMapList)) {
            if (this.hasFileTypeParameter(parameterMapList)) {
                this.adjustConsumesAsMultipart(httpMethodContentMap);
            } else {
                this.adjustConsumesAsFormUrlencoded(httpMethodContentMap);
            }
        }
    }

    protected boolean hasFormDataInput(List<Map<String, Object>> parameterMapList) {
        return parameterMapList.stream().anyMatch(parameterMap -> this.isParameterInputFormData((Map<String, Object>)parameterMap));
    }

    protected boolean hasFileTypeParameter(List<Map<String, Object>> parameterMapList) {
        return parameterMapList.stream().anyMatch(parameterMap -> this.isParameterTypeFile((Map<String, Object>)parameterMap));
    }

    protected void adjustConsumesAsMultipart(Map<String, Object> httpMethodContentMap) {
        httpMethodContentMap.put("consumes", Arrays.asList("multipart/form-data"));
    }

    protected void adjustConsumesAsFormUrlencoded(Map<String, Object> httpMethodContentMap) {
        httpMethodContentMap.put("consumes", Arrays.asList("application/x-www-form-urlencoded"));
    }

    protected boolean isParameterInputFormData(Map<String, Object> parameterMap) {
        return "formData".equals(parameterMap.get("in"));
    }

    protected boolean isParameterInputQuery(Map<String, Object> parameterMap) {
        return "query".equals(parameterMap.get("in"));
    }

    protected boolean isParameterTypeFile(Map<String, Object> parameterMap) {
        return "file".equals(parameterMap.get("type"));
    }
}

