/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.meta.swagger.spec.zone.parameter;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Constraint;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfStringUtil;
import org.dbflute.util.DfTypeUtil;
import org.hibernate.validator.constraints.Length;
import org.lastaflute.meta.document.docmeta.TypeDocMeta;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataType;
import org.lastaflute.meta.swagger.spec.parts.datatype.SwaggerSpecDataTypeHandler;
import org.lastaflute.meta.swagger.spec.parts.defaultvalue.SwaggerSpecDefaultValueHandler;
import org.lastaflute.meta.swagger.spec.parts.definition.SwaggerSpecDefinitionHandler;
import org.lastaflute.meta.swagger.spec.parts.encoding.SwaggerSpecEncodingHandler;
import org.lastaflute.meta.swagger.spec.parts.enumtype.SwaggerSpecEnumHandler;
import org.lastaflute.meta.swagger.spec.parts.property.SwaggerSpecPropertyHandler;
import org.lastaflute.web.api.JsonParameter;
import org.lastaflute.web.response.ActionResponse;

public class SwaggerSpecParameterSetupper {
    protected final List<Class<?>> nativeDataTypeList;
    protected final SwaggerSpecEnumHandler enumHandler;
    protected final SwaggerSpecDataTypeHandler dataTypeHandler;
    protected final SwaggerSpecDefaultValueHandler defaultValueHandler;
    protected final SwaggerSpecPropertyHandler propertyHandler;
    protected final SwaggerSpecDefinitionHandler definitionHandler;
    protected final SwaggerSpecEncodingHandler encodingHandler;

    public SwaggerSpecParameterSetupper(List<Class<?>> nativeDataTypeList, SwaggerSpecEnumHandler enumHandler, SwaggerSpecDataTypeHandler dataTypeHandler, SwaggerSpecDefaultValueHandler defaultValueHandler, SwaggerSpecPropertyHandler propertyHandler, SwaggerSpecDefinitionHandler definitionHandler, SwaggerSpecEncodingHandler encodingHandler) {
        this.nativeDataTypeList = nativeDataTypeList;
        this.enumHandler = enumHandler;
        this.dataTypeHandler = dataTypeHandler;
        this.defaultValueHandler = defaultValueHandler;
        this.propertyHandler = propertyHandler;
        this.definitionHandler = definitionHandler;
        this.encodingHandler = encodingHandler;
    }

    public Map<String, Object> toParameterMap(TypeDocMeta typeDocMeta, Map<String, Map<String, Object>> definitionsMap) {
        Map<Class<?>, SwaggerSpecDataType> typeMap = this.dataTypeHandler.createSwaggerDataTypeMap();
        Class<?> keepType = typeDocMeta.getType();
        if (typeDocMeta.getGenericType() != null && (ActionResponse.class.isAssignableFrom(typeDocMeta.getType()) || OptionalThing.class.isAssignableFrom(typeDocMeta.getType()))) {
            typeDocMeta.setType(typeDocMeta.getGenericType());
        }
        LinkedHashMap parameterMap = DfCollectionUtil.newLinkedHashMap();
        parameterMap.put("name", typeDocMeta.getPublicName());
        if (DfStringUtil.is_NotNull_and_NotEmpty((String)typeDocMeta.getDescription())) {
            parameterMap.put("description", typeDocMeta.getDescription());
        }
        if (typeMap.containsKey(typeDocMeta.getType())) {
            SwaggerSpecDataType swaggerType = typeMap.get(typeDocMeta.getType());
            parameterMap.put("type", swaggerType.type);
            String format = swaggerType.format;
            if (DfStringUtil.is_NotNull_and_NotEmpty((String)format)) {
                parameterMap.put("format", format);
            }
        } else if (typeDocMeta.getAnnotationTypeList().stream().anyMatch(annotationType -> JsonParameter.class.isAssignableFrom(annotationType.getClass()))) {
            parameterMap.put("type", "string");
        } else if (Iterable.class.isAssignableFrom(typeDocMeta.getType())) {
            this.setupArrayAttribute(parameterMap, typeDocMeta, definitionsMap, typeMap);
        } else if (typeDocMeta.getType().equals(Object.class) || Map.class.isAssignableFrom(typeDocMeta.getType())) {
            parameterMap.put("type", "object");
        } else if (Enum.class.isAssignableFrom(typeDocMeta.getType())) {
            Class<?> enumType = typeDocMeta.getType();
            this.setupEnumAttribute(parameterMap, enumType, typeDocMeta);
        } else if (!this.nativeDataTypeList.contains(typeDocMeta.getType())) {
            String definition = this.putDefinitionAttribute(typeDocMeta, definitionsMap);
            parameterMap.clear();
            parameterMap.put("name", typeDocMeta.getPublicName());
            parameterMap.put("$ref", definition);
        } else {
            parameterMap.put("type", "object");
        }
        this.setupValidationAttribute(typeDocMeta, parameterMap);
        this.setupExampleAttribute(typeDocMeta, parameterMap);
        typeDocMeta.setType(keepType);
        return parameterMap;
    }

    protected void setupArrayAttribute(Map<String, Object> schemaMap, TypeDocMeta typeDocMeta, Map<String, Map<String, Object>> definitionsMap, Map<Class<?>, SwaggerSpecDataType> dataTypeMap) {
        schemaMap.put("type", "array");
        if (!typeDocMeta.getNestTypeDocMetaList().isEmpty()) {
            String definition = this.putDefinitionAttribute(typeDocMeta, definitionsMap);
            schemaMap.put("items", DfCollectionUtil.newLinkedHashMap((Object)"$ref", (Object)definition));
        } else {
            LinkedHashMap itemsMap = DfCollectionUtil.newLinkedHashMap();
            Class<?> genericType = typeDocMeta.getGenericType();
            if (genericType != null) {
                SwaggerSpecDataType swaggerDataType = dataTypeMap.get(genericType);
                if (swaggerDataType != null) {
                    itemsMap.put("type", swaggerDataType.type);
                    String format = swaggerDataType.format;
                    if (DfStringUtil.is_NotNull_and_NotEmpty((String)format)) {
                        itemsMap.put("format", format);
                    }
                } else if (Enum.class.isAssignableFrom(genericType)) {
                    Class<?> enumType = genericType;
                    this.setupEnumAttribute(itemsMap, enumType, typeDocMeta);
                }
            }
            if (!itemsMap.containsKey("type")) {
                itemsMap.put("type", "object");
            }
            schemaMap.put("items", itemsMap);
        }
        if (typeDocMeta.getSimpleTypeName().matches(".*List<.*List<.*")) {
            schemaMap.put("items", DfCollectionUtil.newLinkedHashMap((Object)"type", (Object)"array", (Object)"items", (Object)schemaMap.get("items")));
        }
    }

    protected void setupEnumAttribute(Map<String, Object> attrMap, Class<? extends Enum<?>> enumType, TypeDocMeta typeDocMeta) {
        attrMap.put("type", "string");
        List<Map<String, String>> enumMapList = this.prepareEnumMapList(enumType);
        attrMap.put("enum", this.buildEnumCodeList(enumMapList));
        attrMap.put("description", this.buildEnumDescription(enumType, enumMapList, typeDocMeta));
    }

    protected List<Map<String, String>> prepareEnumMapList(Class<? extends Enum<?>> enumType) {
        return this.enumHandler.buildEnumMapList(enumType);
    }

    protected List<String> buildEnumCodeList(List<Map<String, String>> enumMapList) {
        return enumMapList.stream().map(em -> (String)em.get("code")).collect(Collectors.toList());
    }

    protected String buildEnumDescription(Class<? extends Enum<?>> enumType, List<Map<String, String>> enumMapList, TypeDocMeta typeDocMeta) {
        StringBuilder sb = new StringBuilder();
        String description = typeDocMeta.getDescription();
        if (DfStringUtil.is_NotNull_and_NotTrimmedEmpty((String)description)) {
            sb.append(description).append(":");
        }
        String contentExp = enumMapList.stream().map(enumMap -> {
            String code = (String)enumMap.get("code");
            String name = (String)enumMap.get("name");
            String alias = (String)enumMap.get("alias");
            String formatted = name != null && alias != null && name.equals(alias) ? String.format(" * `%s` - %s.", code, name) : String.format(" * `%s` - %s, %s.", code, name, alias);
            return formatted;
        }).collect(Collectors.joining());
        sb.append(contentExp);
        String enumTitle = DfTypeUtil.toClassTitle(enumType);
        sb.append(" :: fromCls(").append(enumTitle).append(")");
        return sb.toString();
    }

    protected void setupValidationAttribute(TypeDocMeta typeDocMeta, Map<String, Object> parameterMap) {
        this.toOrderedAnnotationList(typeDocMeta.getAnnotationTypeList()).forEach(annotation -> {
            this.handleValidationAnnotationIfNeeds((Annotation)annotation, parameterMap);
            this.toOrderedAnnotationList(annotation.annotationType().getAnnotations()).forEach(nestAnno -> this.handleValidationAnnotationIfNeeds((Annotation)nestAnno, parameterMap));
        });
    }

    protected List<Annotation> toOrderedAnnotationList(List<Annotation> providedList) {
        ArrayList<Annotation> orderedList = new ArrayList<Annotation>(providedList);
        Collections.sort(orderedList, Comparator.comparing(anno -> anno.getClass().getName()));
        return orderedList;
    }

    protected List<Annotation> toOrderedAnnotationList(Annotation[] providedAry) {
        return this.toOrderedAnnotationList(Arrays.asList(providedAry));
    }

    protected void handleValidationAnnotationIfNeeds(Annotation annotation, Map<String, Object> parameterMap) {
        if (!this.isValidationAnnotation(annotation)) {
            return;
        }
        this.doHandleValidationLength(annotation, parameterMap);
        this.doHandleValidationSize(annotation, parameterMap);
        this.doHandleValidationPattern(annotation, parameterMap);
        this.doHandleValidationEmail(annotation, parameterMap);
        this.doHandleValidationMinMax(annotation, parameterMap);
    }

    protected boolean isValidationAnnotation(Annotation annotation) {
        return annotation.annotationType().getAnnotation(Constraint.class) != null;
    }

    protected void doHandleValidationLength(Annotation annotation, Map<String, Object> parameterMap) {
        if (annotation instanceof Length) {
            Length length = (Length)annotation;
            parameterMap.put("minLength", length.min());
            parameterMap.put("maxLength", length.max());
        }
    }

    protected void doHandleValidationSize(Annotation annotation, Map<String, Object> parameterMap) {
        if (annotation instanceof Size) {
            Size size = (Size)annotation;
            parameterMap.put("minLength", size.min());
            parameterMap.put("maxLength", size.max());
        }
    }

    protected void doHandleValidationPattern(Annotation annotation, Map<String, Object> parameterMap) {
        if (annotation instanceof Pattern) {
            Pattern pattern = (Pattern)annotation;
            parameterMap.put("pattern", pattern.regexp());
        }
    }

    protected void doHandleValidationEmail(Annotation annotation, Map<String, Object> parameterMap) {
        if (annotation instanceof Email) {
            Email email = (Email)annotation;
            parameterMap.put("pattern", email.regexp());
        }
    }

    protected void doHandleValidationMinMax(Annotation annotation, Map<String, Object> parameterMap) {
        if (annotation instanceof Min) {
            Min min = (Min)annotation;
            parameterMap.put("minimum", min.value());
        }
        if (annotation instanceof Max) {
            Max max = (Max)annotation;
            parameterMap.put("maximum", max.value());
        }
    }

    protected void setupExampleAttribute(TypeDocMeta typeDocMeta, Map<String, Object> parameterMap) {
        this.defaultValueHandler.deriveDefaultValue(typeDocMeta).ifPresent(defaultValue -> parameterMap.put("example", defaultValue));
    }

    protected String putDefinitionAttribute(TypeDocMeta typeDocMeta, Map<String, Map<String, Object>> definitionsMap) {
        String derivedDefinitionName = this.definitionHandler.deriveDefinitionName(typeDocMeta);
        if (!definitionsMap.containsKey(derivedDefinitionName)) {
            LinkedHashMap schema = DfCollectionUtil.newLinkedHashMap();
            schema.put("type", "object");
            List<String> requiredPropertyNameList = this.propertyHandler.deriveRequiredPropertyNameList(typeDocMeta);
            if (!requiredPropertyNameList.isEmpty()) {
                schema.put("required", requiredPropertyNameList);
            }
            schema.put("properties", typeDocMeta.getNestTypeDocMetaList().stream().map(nestTypeDocMeta -> this.toParameterMap((TypeDocMeta)nestTypeDocMeta, definitionsMap)).collect(Collectors.toMap(key -> key.get("name"), value -> {
                LinkedHashMap property = DfCollectionUtil.newLinkedHashMap((Map)value);
                property.remove("name");
                return property;
            }, (u, v) -> v, LinkedHashMap::new)));
            definitionsMap.put(derivedDefinitionName, schema);
        }
        return "#/definitions/" + this.encodingHandler.encode(derivedDefinitionName);
    }
}

